/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import io.netty.util.Recycler;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetlinks.core.utils.RecyclableDequeue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ConcurrentReferenceHashMap;

public class RecyclerUtils {
    private static final Logger log = LoggerFactory.getLogger(RecyclerUtils.class);
    private static final Map<Object, Object> staticSharedObject = new ConcurrentHashMap<Object, Object>();
    private static final Map<Object, Object> sharedObjects = new ConcurrentReferenceHashMap(65535, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    public static final boolean INTERN_ENABLED = "true".equals(System.getProperty("jetlinks.recycler.intern.enabled", "true"));

    public static void clean() {
        sharedObjects.clear();
    }

    public static <T> T intern(T obj) {
        if (!INTERN_ENABLED || obj == null) {
            return obj;
        }
        Object v = staticSharedObject.get(obj);
        if (v != null) {
            return (T)v;
        }
        return (T)sharedObjects.computeIfAbsent(obj, Function.identity());
    }

    public static void share(Object object) {
        staticSharedObject.put(object, object);
    }

    public static <T> Recycler<T> newRecycler(Class<T> type, final Function<Recycler.Handle<T>, T> objectSupplier, int defaultRatio) {
        int maxCapacityPerThread = RecyclerUtils.getPoolConfig(type, "maxCapacityPerThread").map(Integer::parseInt).orElse(4096);
        int maxSharedCapacityFactor = RecyclerUtils.getPoolConfig(type, "maxSharedCapacityFactor").map(Integer::parseInt).orElse(2);
        int maxDelayedQueuesPerThread = RecyclerUtils.getPoolConfig(type, "maxDelayedQueuesPerThread").map(Integer::parseInt).orElse(Runtime.getRuntime().availableProcessors() * 2);
        int ratio = RecyclerUtils.getPoolConfig(type, "ratio").map(Integer::parseInt).orElse(defaultRatio);
        if (log.isDebugEnabled()) {
            log.debug("-D{}: {}", (Object)RecyclerUtils.getConfigName(type, "maxCapacityPerThread"), (Object)maxCapacityPerThread);
            log.debug("-D{}: {}", (Object)RecyclerUtils.getConfigName(type, "maxSharedCapacityFactor"), (Object)maxSharedCapacityFactor);
            log.debug("-D{}: {}", (Object)RecyclerUtils.getConfigName(type, "maxDelayedQueuesPerThread"), (Object)maxDelayedQueuesPerThread);
            log.debug("-D{}: {}", (Object)RecyclerUtils.getConfigName(type, "ratio"), (Object)ratio);
        }
        return new Recycler<T>(maxCapacityPerThread, maxSharedCapacityFactor, ratio, maxDelayedQueuesPerThread){

            protected T newObject(Recycler.Handle<T> handle) {
                return objectSupplier.apply(handle);
            }
        };
    }

    public static <T> Recycler<T> newRecycler(Class<T> type, Function<Recycler.Handle<T>, T> objectSupplier) {
        return RecyclerUtils.newRecycler(type, objectSupplier, 8);
    }

    private static Optional<String> getPoolConfig(Class<?> type, String key) {
        return Optional.ofNullable(System.getProperty(RecyclerUtils.getConfigName(type, key)));
    }

    private static String getConfigName(Class<?> type, String key) {
        return (type.getName() + ".pool." + key).replace("$$", ".").replace("$", ".");
    }

    public static <T> RecyclableDequeue<T> dequeue() {
        return RecyclableDequeue.newInstance();
    }

    static {
        RecyclerUtils.share("");
        RecyclerUtils.share("*");
        RecyclerUtils.share("**");
        RecyclerUtils.share("device");
        RecyclerUtils.share("product");
        RecyclerUtils.share("org");
        RecyclerUtils.share("user");
        RecyclerUtils.share("creatorId");
        RecyclerUtils.share("message");
        RecyclerUtils.share("online");
        RecyclerUtils.share("offline");
        RecyclerUtils.share("property");
        RecyclerUtils.share("report");
        RecyclerUtils.share("reply");
        RecyclerUtils.share("read");
        RecyclerUtils.share("write");
        RecyclerUtils.share("properties");
        RecyclerUtils.share("function");
        RecyclerUtils.share("event");
        RecyclerUtils.share("_sys");
    }
}

