/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.Queues;
import reactor.util.context.ContextView;

public interface Reactors {
    public static final Mono<Boolean> ALWAYS_TRUE = Mono.just((Object)true);
    public static final Mono<Boolean> ALWAYS_FALSE = Mono.just((Object)false);
    public static final Mono<Integer> ALWAYS_ZERO = Mono.just((Object)0);
    public static final Mono<Integer> ALWAYS_ONE = Mono.just((Object)1);
    public static final Mono<Long> ALWAYS_ONE_LONG = Mono.just((Object)1L);
    public static final Mono<Long> ALWAYS_ZERO_LONG = Mono.just((Object)0L);
    public static final Sinks.EmitFailureHandler RETRY_NON_SERIALIZED = (signal, failure) -> failure == Sinks.EmitResult.FAIL_NON_SERIALIZED;

    public static Sinks.EmitFailureHandler emitFailureHandler() {
        return RETRY_NON_SERIALIZED;
    }

    public static Sinks.EmitFailureHandler retryNonSerialized() {
        return RETRY_NON_SERIALIZED;
    }

    public static <T> Sinks.Many<T> createMany(int bufferSize, boolean autoCancel) {
        return Sinks.many().multicast().onBackpressureBuffer(bufferSize, autoCancel);
    }

    public static <T> Sinks.Many<T> createMany(boolean autoCancel) {
        return Reactors.createMany(Queues.SMALL_BUFFER_SIZE, autoCancel);
    }

    public static <T> Sinks.Many<T> createMany() {
        return Reactors.createMany(false);
    }

    public static <T> Flux<T> doWhenContext(Predicate<ContextView> predicate, Flux<T> flux) {
        return Flux.deferContextual(ctx -> {
            if (predicate.test((ContextView)ctx)) {
                return flux;
            }
            return Flux.empty();
        });
    }

    public static <T> Mono<T> doWhenContext(Predicate<ContextView> predicate, Mono<T> mono) {
        return Mono.deferContextual(ctx -> {
            if (predicate.test((ContextView)ctx)) {
                return mono;
            }
            return Mono.empty();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T await(Mono<T> mono, Duration timeout) {
        if (mono instanceof Callable) {
            return (T)((Callable)mono).call();
        }
        if (!Schedulers.isNonBlockingThread((Thread)Thread.currentThread())) {
            if (!timeout.isZero()) return (T)mono.block(timeout);
        }
        CompletableFuture future = mono.toFuture();
        try {
            if (timeout.isZero()) {
                T t = future.getNow(null);
                return t;
            }
            Object t = future.get(timeout.getNano(), TimeUnit.NANOSECONDS);
            return t;
        }
        finally {
            future.cancel(true);
        }
    }
}

