/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;

public class HashUtils {
    public static long murmur3_128(Object first, Object ... another) {
        return HashUtils.putHash(Hashing.murmur3_128().newHasher(), first, another).hash().asLong();
    }

    public static Hasher putHash(Hasher hasher, Object key) {
        if (key instanceof String) {
            return hasher.putUnencodedChars((CharSequence)((String)key));
        }
        if (key instanceof BigDecimal) {
            return hasher.putBytes(((BigDecimal)key).toBigInteger().toByteArray());
        }
        if (key instanceof BigInteger) {
            return hasher.putBytes(((BigInteger)key).toByteArray());
        }
        if (key instanceof Number) {
            return hasher.putDouble(((Number)key).doubleValue());
        }
        if (key.getClass().isArray()) {
            if (key instanceof byte[]) {
                return hasher.putBytes((byte[])key);
            }
            int len = Array.getLength(key);
            for (int i = 0; i < len; ++i) {
                HashUtils.putHash(hasher, Array.get(key, i));
            }
            return hasher;
        }
        if (key instanceof Iterable) {
            for (Object ele : (Iterable)key) {
                HashUtils.putHash(hasher, ele);
            }
            return hasher;
        }
        return hasher.putInt(key == null ? 0 : key.hashCode());
    }

    public static Hasher putHash(Hasher hasher, Object first, Object ... objects) {
        HashUtils.putHash(hasher, first);
        for (Object object : objects) {
            HashUtils.putHash(hasher, object);
        }
        return hasher;
    }
}

