/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.message.HeaderKey;
import org.springframework.core.ResolvableType;

public class ConverterUtils {
    public static <T> T convert(Object value, HeaderKey<T> key) {
        return ConverterUtils.convert(value, key.getValueType());
    }

    static Object getNullValue(Type type) {
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    public static <T> T convert(Object value, Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (value == null) {
            return (T)ConverterUtils.getNullValue(type);
        }
        if (type == Object.class || type instanceof Class && ((Class)type).isInstance(value)) {
            return (T)value;
        }
        if (type instanceof Class) {
            return (T)FastBeanCopier.DEFAULT_CONVERT.convert(value, (Class)type, FastBeanCopier.EMPTY_CLASS_ARRAY);
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Type[] args = parameterizedType.getActualTypeArguments();
            Class[] arg = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                arg[i] = args[i] instanceof Class ? (Class)args[i] : ResolvableType.forType((Type)args[i]).toClass();
            }
            return (T)FastBeanCopier.DEFAULT_CONVERT.convert(value, (Class)rawType, arg);
        }
        return (T)TypeUtils.cast((Object)value, (Type)type, (ParserConfig)ParserConfig.getGlobalInstance());
    }
}

