/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.jetlinks.core.utils.CompositeCollection;

public class CompositeList<E>
extends CompositeCollection<E>
implements List<E> {
    public CompositeList(List<E> first, List<E> second) {
        super(first, second);
    }

    List<E> first() {
        return (List)this.first;
    }

    List<E> second() {
        return (List)this.second;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        List<E> first = this.first();
        int firstSize = first.size();
        if (index < firstSize) {
            return first.get(index);
        }
        return this.second().get(index - firstSize);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        int fistIndex = this.first().indexOf(o);
        if (fistIndex > 0) {
            return fistIndex;
        }
        int secondIndex = this.second().indexOf(o);
        if (secondIndex > 0) {
            return secondIndex + this.first.size();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int fistIndex = this.first().lastIndexOf(o);
        if (fistIndex > 0) {
            return fistIndex + this.second.size();
        }
        int secondIndex = this.second().lastIndexOf(o);
        if (secondIndex > 0) {
            return secondIndex + this.first.size();
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        int size = this.size();
        if (index >= size) {
            throw new IndexOutOfBoundsException("index:" + index + ",size:" + size);
        }
        return new CompositeListIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < this.first().size()) {
            if (toIndex < this.first().size()) {
                return this.first().subList(fromIndex, toIndex);
            }
            return new CompositeList<E>(this.first().subList(fromIndex, this.first().size()), this.second().subList(0, toIndex - this.first().size()));
        }
        return this.second().subList(fromIndex - this.first().size(), toIndex - this.first().size());
    }

    class CompositeListIterator
    implements ListIterator<E> {
        private int index;

        CompositeListIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return CompositeList.this.size() > this.index;
        }

        @Override
        public E next() {
            return CompositeList.this.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            return CompositeList.this.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            CompositeList.this.remove(this.index);
        }

        @Override
        public void set(E e) {
            CompositeList.this.set(this.index, e);
        }

        @Override
        public void add(E e) {
            CompositeList.this.add(this.index, e);
        }
    }
}

