/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace.data;

import com.google.common.collect.Maps;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.trace.data.SpanEventDataInfo;
import org.jetlinks.core.utils.RecyclerUtils;
import org.jetlinks.core.utils.SerializeUtils;

public class SpanDataInfo
implements Externalizable {
    private static final long serialVersionUID = -1L;
    private String app;
    private String name;
    private String traceId;
    private String spanId;
    private String parentSpanId;
    private long startWithNanos;
    private long endWithNanos;
    private Map<String, Object> attributes;
    private List<SpanEventDataInfo> events;
    private transient List<? extends SpanDataInfo> children;

    public static SpanDataInfo of(SpanData data) {
        return new SpanDataInfo().with(data);
    }

    public SpanDataInfo with(SpanData data) {
        List eventData;
        this.app = data.getInstrumentationScopeInfo().getName();
        this.name = data.getName();
        this.traceId = data.getTraceId();
        this.spanId = data.getSpanId();
        this.parentSpanId = data.getParentSpanId();
        this.startWithNanos = data.getStartEpochNanos();
        this.endWithNanos = data.getEndEpochNanos();
        Attributes attr = data.getAttributes();
        if (!attr.isEmpty()) {
            this.attributes = Maps.newHashMapWithExpectedSize((int)attr.size());
            attr.forEach((k, v) -> {
                if (v instanceof Supplier) {
                    v = ((Supplier)v).get();
                }
                this.attributes.put(k.getKey(), v);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(eventData = data.getEvents()))) {
            this.events = new ArrayList<SpanEventDataInfo>();
            for (EventData eventDatum : eventData) {
                this.events.add(SpanEventDataInfo.of(eventDatum));
            }
        }
        return this;
    }

    public Optional<SpanEventDataInfo> getEvent(String name) {
        if (this.events == null) {
            return Optional.empty();
        }
        for (SpanEventDataInfo eventInfo : this.events) {
            if (!Objects.equals(name, eventInfo.getName())) continue;
            return Optional.of(eventInfo);
        }
        return Optional.empty();
    }

    public <T> Optional<T> getAttribute(String key) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.attributes.get(key));
    }

    public <T> Optional<T> getAttribute(AttributeKey<T> key) {
        return this.getAttribute(key.getKey());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(2);
        out.writeUTF(this.app);
        out.writeUTF(this.name);
        out.writeUTF(this.traceId);
        out.writeUTF(this.spanId);
        out.writeUTF(this.parentSpanId);
        out.writeLong(this.startWithNanos);
        out.writeLong(this.endWithNanos);
        SerializeUtils.writeKeyValue(this.attributes, out);
        if (this.events == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.events.size());
            for (SpanEventDataInfo event : this.events) {
                event.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readUnsignedByte();
        this.app = RecyclerUtils.intern(in.readUTF());
        this.name = RecyclerUtils.intern(in.readUTF());
        this.traceId = in.readUTF();
        this.spanId = in.readUTF();
        this.parentSpanId = in.readUTF();
        this.startWithNanos = in.readLong();
        this.endWithNanos = in.readLong();
        this.attributes = SerializeUtils.readMap(in, e -> RecyclerUtils.intern(String.valueOf(e)), Function.identity(), Maps::newHashMapWithExpectedSize);
        int eventSize = in.readInt();
        if (eventSize > 0) {
            this.events = new ArrayList<SpanEventDataInfo>(eventSize);
            for (int i = 0; i < eventSize; ++i) {
                SpanEventDataInfo dataInfo = new SpanEventDataInfo();
                dataInfo.readExternal(in);
                this.events.add(dataInfo);
            }
        }
    }

    public String getApp() {
        return this.app;
    }

    public String getName() {
        return this.name;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public String getParentSpanId() {
        return this.parentSpanId;
    }

    public long getStartWithNanos() {
        return this.startWithNanos;
    }

    public long getEndWithNanos() {
        return this.endWithNanos;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public List<SpanEventDataInfo> getEvents() {
        return this.events;
    }

    public List<? extends SpanDataInfo> getChildren() {
        return this.children;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public void setParentSpanId(String parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    public void setStartWithNanos(long startWithNanos) {
        this.startWithNanos = startWithNanos;
    }

    public void setEndWithNanos(long endWithNanos) {
        this.endWithNanos = endWithNanos;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setEvents(List<SpanEventDataInfo> events) {
        this.events = events;
    }

    public void setChildren(List<? extends SpanDataInfo> children) {
        this.children = children;
    }
}

