/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.Lazy;
import org.jetlinks.core.LazyConverter;
import org.jetlinks.core.trace.ReactiveSpan;

public class ReactiveSpanWrapper
implements ReactiveSpan {
    private final Span span;

    @Override
    public <T> ReactiveSpan setAttributeLazy(AttributeKey<T> key, Supplier<T> lazyValue) {
        this.span.setAttribute(key, lazyValue instanceof Lazy ? lazyValue : Lazy.of(lazyValue));
        return this;
    }

    @Override
    public <V, T> ReactiveSpan setAttributeLazy(AttributeKey<T> key, V value, Function<V, T> lazyValue) {
        this.span.setAttribute(key, lazyValue instanceof LazyConverter ? lazyValue : LazyConverter.of(value, lazyValue));
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull String key, double value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull String key, long value) {
        this.span.setAttribute(key, value);
        return this;
    }

    public <R> ReactiveSpan setAttribute(@Nonnull AttributeKey<R> key, @Nonnull R value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull String key, @Nonnull String value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull String key, boolean value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setAttribute(@Nonnull AttributeKey<Long> key, int value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public ReactiveSpan setStatus(@Nonnull StatusCode statusCode) {
        this.span.setStatus(statusCode);
        return this;
    }

    public Span setAllAttributes(@Nonnull Attributes attributes) {
        this.span.setAllAttributes(attributes);
        return this;
    }

    public ReactiveSpan addEvent(@Nonnull String name, @Nonnull Attributes attributes) {
        this.span.addEvent(name, attributes);
        return this;
    }

    public ReactiveSpan addEvent(@Nonnull String name, @Nonnull Attributes attributes, long timestamp, @Nonnull TimeUnit unit) {
        this.span.addEvent(name, attributes, timestamp, unit);
        return this;
    }

    @Override
    public ReactiveSpan setStatus(@Nonnull StatusCode statusCode, @Nonnull String description) {
        this.span.setStatus(statusCode, description);
        return this;
    }

    public ReactiveSpan recordException(@Nonnull Throwable exception, @Nonnull Attributes additionalAttributes) {
        this.span.recordException(exception, additionalAttributes);
        return this;
    }

    public ReactiveSpan updateName(@Nonnull String name) {
        this.span.updateName(name);
        return this;
    }

    public void end() {
    }

    public void end(long timestamp, @Nonnull TimeUnit unit) {
    }

    public SpanContext getSpanContext() {
        return this.span.getSpanContext();
    }

    public boolean isRecording() {
        return this.span.isRecording();
    }

    public Context storeInContext(@Nonnull Context context) {
        return this.span.storeInContext(context);
    }

    public ReactiveSpanWrapper(Span span) {
        this.span = span;
    }
}

