/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import org.jetlinks.core.trace.AbstractReactiveTracerBuilder;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.trace.ReactiveSpan;
import org.jetlinks.core.trace.TraceFlux;
import org.jetlinks.core.trace.TraceHolder;
import reactor.core.publisher.Flux;
import reactor.function.Consumer3;
import reactor.util.context.ContextView;

class FluxTracerBuilder<T>
extends AbstractReactiveTracerBuilder<FluxTracer<T>, T>
implements FluxTracer<T> {
    private boolean fastSubscribe;

    @Override
    public FluxTracer<T> build() {
        return this;
    }

    @Override
    public Flux<T> apply(Flux<T> source) {
        return new TraceFlux<T>(source, this.spanName, TraceHolder.telemetry().getTracer(this.scopeName), this.onNext, (Consumer3<ContextView, ReactiveSpan, Long>)this.onComplete, this.onSubscription, this.onError, this.fastSubscribe, this.defaultContext);
    }

    private FluxTracerBuilder(boolean fastSubscribe) {
        this.fastSubscribe = fastSubscribe;
    }

    public static <T> FluxTracerBuilder<T> create(boolean fastSubscribe) {
        return new FluxTracerBuilder<T>(fastSubscribe);
    }

    public FluxTracerBuilder() {
    }
}

