/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.core.trace.FluxTracerBuilder;
import org.jetlinks.core.trace.MapTextMapGetter;
import org.jetlinks.core.trace.ReactiveSpan;
import org.jetlinks.core.trace.ReactiveSpanBuilder;
import org.jetlinks.core.trace.ReactiveTracerBuilder;
import org.jetlinks.core.trace.TraceHolder;
import reactor.core.publisher.Flux;
import reactor.util.context.ContextView;

public interface FluxTracer<T>
extends Function<Flux<T>, Flux<T>> {
    public static <T> FluxTracer<T> unsupported() {
        return source -> source;
    }

    public static <T> ReactiveTracerBuilder<FluxTracer<T>, T> builder() {
        return new FluxTracerBuilder();
    }

    public static <T> FluxTracer<T> create(String spanName) {
        return FluxTracer.create(TraceHolder.appName(), spanName);
    }

    public static <T> FluxTracer<T> create(CharSequence spanName) {
        return FluxTracer.create(TraceHolder.appName(), spanName);
    }

    public static <T> FluxTracer<T> create(String scopeName, String spanName) {
        return FluxTracer.create(scopeName, spanName, null, null);
    }

    public static <T> FluxTracer<T> create(String scopeName, CharSequence spanName) {
        return FluxTracer.create(scopeName, spanName, null, null);
    }

    public static <T> FluxTracer<T> create(String spanName, BiConsumer<ReactiveSpan, T> onNext) {
        return FluxTracer.create(TraceHolder.appName(), spanName, onNext, null);
    }

    public static <T> FluxTracer<T> create(CharSequence spanName, BiConsumer<ReactiveSpan, T> onNext) {
        return FluxTracer.create(TraceHolder.appName(), spanName, onNext, null);
    }

    public static <T> FluxTracer<T> create(String scopeName, String spanName, BiConsumer<ReactiveSpan, T> onNext) {
        return FluxTracer.create(scopeName, spanName, onNext, null);
    }

    public static <T> FluxTracer<T> create(String spanName, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return FluxTracer.create(TraceHolder.appName(), spanName, null, builderConsumer);
    }

    public static <T> FluxTracer<T> create(CharSequence spanName, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return FluxTracer.create(TraceHolder.appName(), spanName, null, builderConsumer);
    }

    public static <T> FluxTracer<T> create(String scopeName, String spanName, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return FluxTracer.create(scopeName, spanName, null, builderConsumer);
    }

    public static <T> FluxTracer<T> create(String spanName, BiConsumer<ReactiveSpan, T> onNext, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return FluxTracer.create(TraceHolder.appName(), spanName, onNext, builderConsumer);
    }

    public static <T> FluxTracer<T> create(CharSequence spanName, BiConsumer<ReactiveSpan, T> onNext, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return FluxTracer.create(TraceHolder.appName(), spanName, onNext, builderConsumer);
    }

    public static <T> FluxTracer<T> create(String spanName, BiConsumer<ReactiveSpan, T> onNext, BiConsumer<ReactiveSpan, Long> onComplete) {
        return FluxTracer.create(TraceHolder.appName(), spanName, onNext, onComplete, null);
    }

    public static <T> FluxTracer<T> create(String scopeName, String spanName, BiConsumer<ReactiveSpan, T> onNext, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return FluxTracer.create(scopeName, spanName, onNext, null, builderConsumer);
    }

    public static <T> FluxTracer<T> create(String scopeName, CharSequence spanName, BiConsumer<ReactiveSpan, T> onNext, Consumer<ReactiveSpanBuilder> builderConsumer) {
        return FluxTracer.create(scopeName, spanName, onNext, null, builderConsumer);
    }

    public static <T> FluxTracer<T> create(String scopeName, String spanName, BiConsumer<ReactiveSpan, T> onNext, BiConsumer<ReactiveSpan, Long> onComplete, Consumer<ReactiveSpanBuilder> builderConsumer) {
        if (TraceHolder.isDisabled(spanName)) {
            return FluxTracer.unsupported();
        }
        return (FluxTracer)FluxTracerBuilder.create(true).scopeName(scopeName).spanName(spanName).onNext(onNext).onComplete(onComplete).onSubscription(builderConsumer).build();
    }

    public static <T> FluxTracer<T> create(String scopeName, CharSequence spanName, BiConsumer<ReactiveSpan, T> onNext, BiConsumer<ReactiveSpan, Long> onComplete, Consumer<ReactiveSpanBuilder> builderConsumer) {
        if (TraceHolder.isDisabled(spanName)) {
            return FluxTracer.unsupported();
        }
        return (FluxTracer)FluxTracerBuilder.create(true).scopeName(scopeName).spanName(spanName).onNext(onNext).onComplete(onComplete).onSubscription(builderConsumer).build();
    }

    public static <R> FluxTracer<R> createWith(Map<String, ?> carrier) {
        if (TraceHolder.isDisabled() || MapUtils.isEmpty(carrier)) {
            return FluxTracer.unsupported();
        }
        return FluxTracer.createWith(carrier, MapTextMapGetter.instance());
    }

    public static <T, R> FluxTracer<R> createWith(T source, TextMapGetter<T> getter) {
        if (TraceHolder.isDisabled()) {
            return FluxTracer.unsupported();
        }
        return flux -> flux.contextWrite(ctx -> TraceHolder.readToContext((ContextView)ctx, source, getter));
    }
}

