/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.trace.data.SpanDataInfo;
import org.jetlinks.core.utils.TopicUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public class EventBusSpanProcessor
implements SpanProcessor {
    private final EventBus eventBus;
    private final Map<String, SharedPathString> prefixCache = new ConcurrentReferenceHashMap();

    public void onStart(@Nonnull Context parentContext, @Nonnull ReadWriteSpan span) {
    }

    public boolean isStartRequired() {
        return false;
    }

    private SeparatedCharSequence prefix(ReadableSpan span) {
        return this.prefixCache.computeIfAbsent(span.getInstrumentationScopeInfo().getName(), name -> SharedPathString.of(new String[]{"", "trace", name}));
    }

    public void onEnd(@Nonnull ReadableSpan span) {
        Context ctx = Context.current();
        CharSequence name = (CharSequence)ctx.get(TraceHolder.SPAN_NAME);
        if (name == null) {
            name = SharedPathString.of(TopicUtils.split(span.getName(), true, false));
        }
        SeparatedCharSequence topic = this.prefix(span).append(name);
        this.eventBus.publish((CharSequence)topic, () -> SpanDataInfo.of(span.toSpanData())).subscribe();
    }

    public boolean isEndRequired() {
        return true;
    }

    private EventBusSpanProcessor(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public static EventBusSpanProcessor create(EventBus eventBus) {
        return new EventBusSpanProcessor(eventBus);
    }
}

