/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import com.google.common.collect.Maps;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hswebframework.web.exception.TraceSourceException;
import org.jetlinks.core.utils.ExceptionUtils;

class ErrorAttributes
implements Attributes {
    static final AttributeKey<String> ATTR_EXCEPTION_OPERATION = AttributeKey.stringKey((String)"exception.operation");
    static final AttributeKey<String> ATTR_EXCEPTION_SOURCE = AttributeKey.stringKey((String)"exception.source");
    static final AttributeKey<String> ATTR_EXCEPTION_TYPE = AttributeKey.stringKey((String)"exception.type");
    static final AttributeKey<String> ATTR_EXCEPTION_MESSAGE = AttributeKey.stringKey((String)"exception.message");
    static final AttributeKey<String> ATTR_EXCEPTION_STACK = AttributeKey.stringKey((String)"exception.stacktrace");
    final Throwable error;
    volatile Map<AttributeKey<?>, Object> parsed;

    @Nullable
    public <T> T get(@Nonnull AttributeKey<T> key) {
        return (T)this.asMap().get(key);
    }

    public void forEach(@Nonnull BiConsumer<? super AttributeKey<?>, ? super Object> consumer) {
        this.asMap().forEach(consumer);
    }

    public int size() {
        return this.asMap().size();
    }

    public boolean isEmpty() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AttributeKey<?>, Object> asMap() {
        if (this.parsed == null) {
            ErrorAttributes errorAttributes = this;
            synchronized (errorAttributes) {
                if (this.parsed == null) {
                    this.parsed = this.parse();
                    return this.parsed;
                }
            }
        }
        return this.parsed;
    }

    private Map<AttributeKey<?>, Object> parse() {
        HashMap container = Maps.newHashMapWithExpectedSize((int)5);
        container.put(ATTR_EXCEPTION_MESSAGE, this.error.getLocalizedMessage());
        container.put(ATTR_EXCEPTION_TYPE, this.error.getClass().getCanonicalName());
        container.put(ATTR_EXCEPTION_STACK, ExceptionUtils.getStackTrace(this.error));
        String operation = TraceSourceException.tryGetOperation((Throwable)this.error);
        Object source = TraceSourceException.tryGetSource((Throwable)this.error);
        if (operation != null) {
            container.put(ATTR_EXCEPTION_OPERATION, operation);
        }
        if (source != null) {
            container.put(ATTR_EXCEPTION_SOURCE, source);
        }
        return container;
    }

    public AttributesBuilder toBuilder() {
        return Attributes.builder().putAll((Attributes)this);
    }

    public ErrorAttributes(Throwable error) {
        this.error = error;
    }
}

