/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.common.AttributeKey;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.utils.StringBuilderUtils;
import reactor.core.publisher.Mono;

public interface DeviceTracer {
    public static <R> MonoTracer<R> fromMessage(Message message) {
        return MonoTracer.createWith(message.getHeaders());
    }

    public static <R extends Message> Mono<R> writeToMessage(R message) {
        return TraceHolder.writeContextTo(message, Message::addHeader);
    }

    public static interface SpanName {
        public static final SharedPathString all_operations = SharedPathString.of("/device/*/*");

        public static SeparatedCharSequence operation0(String deviceId, String operation) {
            return all_operations.replace(2, deviceId, 3, operation);
        }

        public static String operation(String deviceId, String operation) {
            return StringBuilderUtils.buildString(deviceId, operation, (str, opt, stringBuilder) -> stringBuilder.append("/device/").append((String)str).append("/").append((String)opt));
        }

        public static String connection(String deviceId) {
            return SpanName.operation(deviceId, "connection");
        }

        public static SeparatedCharSequence connection0(String deviceId) {
            return SpanName.operation0(deviceId, "connection");
        }

        public static String auth(String deviceId) {
            return SpanName.operation(deviceId, "auth");
        }

        public static SeparatedCharSequence auth0(String deviceId) {
            return SpanName.operation0(deviceId, "auth");
        }

        public static String decode(String deviceId) {
            return SpanName.operation(deviceId, "decode");
        }

        public static SeparatedCharSequence decode0(String deviceId) {
            return SpanName.operation0(deviceId, "decode");
        }

        public static String encode(String deviceId) {
            return SpanName.operation(deviceId, "encode");
        }

        public static SeparatedCharSequence encode0(String deviceId) {
            return SpanName.operation0(deviceId, "encode");
        }

        public static String request(String deviceId) {
            return SpanName.operation(deviceId, "request");
        }

        public static SeparatedCharSequence request0(String deviceId) {
            return SpanName.operation0(deviceId, "request");
        }

        public static String response(String deviceId) {
            return SpanName.operation(deviceId, "response");
        }

        public static SeparatedCharSequence response0(String deviceId) {
            return SpanName.operation0(deviceId, "response");
        }

        public static String downstream(String deviceId) {
            return SpanName.operation(deviceId, "downstream");
        }

        public static SeparatedCharSequence downstream0(String deviceId) {
            return SpanName.operation0(deviceId, "downstream");
        }

        public static String upstream(String deviceId) {
            return SpanName.operation(deviceId, "upstream");
        }

        public static SeparatedCharSequence upstream0(String deviceId) {
            return SpanName.operation0(deviceId, "upstream");
        }
    }

    public static interface SpanKey {
        public static final AttributeKey<String> deviceId = AttributeKey.stringKey((String)"deviceId");
        public static final AttributeKey<String> message = AttributeKey.stringKey((String)"message");
        public static final AttributeKey<String> response = AttributeKey.stringKey((String)"response");
        public static final AttributeKey<String> address = AttributeKey.stringKey((String)"address");
    }
}

