/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things.relation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.things.relation.ObjectProperty;
import org.jetlinks.core.utils.SerializeUtils;

public class SimpleObjectProperty
implements ObjectProperty,
Externalizable {
    private String property;
    private Object value;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.property);
        SerializeUtils.writeObject(this.value, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.property = in.readUTF();
        this.value = SerializeUtils.readObject(in);
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private SimpleObjectProperty(String property, Object value) {
        this.property = property;
        this.value = value;
    }

    public static SimpleObjectProperty of(String property, Object value) {
        return new SimpleObjectProperty(property, value);
    }

    public SimpleObjectProperty() {
    }
}

