/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things.relation;

import java.util.Collection;
import org.jetlinks.core.things.relation.ObjectSpec;
import org.jetlinks.core.things.relation.ObjectType;
import org.jetlinks.core.things.relation.RelationObject;
import org.jetlinks.core.things.relation.RelationSpec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface RelationManager {
    public Mono<ObjectType> getObjectType(String var1);

    public Flux<ObjectType> getObjectTypes();

    public Mono<RelationObject> getObject(String var1, String var2);

    public Flux<RelationObject> getObjects(String var1, Collection<String> var2);

    default public Flux<RelationObject> getObjects(ObjectSpec spec) {
        Flux first = this.getObject(spec.getObjectType(), spec.getObjectId()).flux();
        RelationSpec rel = spec.getRelated();
        while (rel != null) {
            RelationSpec fRel = rel;
            first = first.flatMap(obj -> obj.relations(fRel.isReverse()).get(fRel.getObjectType(), fRel.getRelation(), new String[0]));
            rel = fRel.getNext();
        }
        return first;
    }
}

