/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.metadata.MergeOption;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;

public interface ThingMetadata
extends Metadata,
Jsonable {
    public List<PropertyMetadata> getProperties();

    public List<FunctionMetadata> getFunctions();

    public List<EventMetadata> getEvents();

    public List<PropertyMetadata> getTags();

    default public List<ThingMetadata> getModules() {
        return Collections.emptyList();
    }

    default public ThingMetadata getModuleOrNull(String moduleId) {
        return this.getModule(moduleId).orElse(null);
    }

    default public Optional<ThingMetadata> getModule(String moduleId) {
        return this.getModules().stream().filter(metadata -> Objects.equals(moduleId, metadata.getId())).findAny();
    }

    default public Optional<EventMetadata> getEvent(String id) {
        return Optional.ofNullable(this.getEventOrNull(id));
    }

    public EventMetadata getEventOrNull(String var1);

    default public Optional<PropertyMetadata> getProperty(String id) {
        return Optional.ofNullable(this.getPropertyOrNull(id));
    }

    public PropertyMetadata getPropertyOrNull(String var1);

    default public Optional<FunctionMetadata> getFunction(String id) {
        return Optional.ofNullable(this.getFunctionOrNull(id));
    }

    public FunctionMetadata getFunctionOrNull(String var1);

    default public Optional<PropertyMetadata> getTag(String id) {
        return Optional.ofNullable(this.getTagOrNull(id));
    }

    public PropertyMetadata getTagOrNull(String var1);

    default public PropertyMetadata findProperty(Predicate<PropertyMetadata> predicate) {
        return this.getProperties().stream().filter(predicate).findAny().orElse(null);
    }

    default public <T extends ThingMetadata> ThingMetadata merge(T metadata) {
        return this.merge(metadata, MergeOption.DEFAULT_OPTIONS);
    }

    default public <T extends ThingMetadata> ThingMetadata merge(T metadata, MergeOption ... options) {
        throw new UnsupportedOperationException("unsupported merge metadata");
    }

    @Override
    default public ThingMetadata expand(String key, Object value) {
        Metadata.super.expand(key, value);
        return this;
    }

    @Override
    default public <T> ThingMetadata expand(ConfigKey<T> key, T value) {
        Metadata.super.expand(key, value);
        return this;
    }

    @Override
    default public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("name", (Object)this.getName());
        json.put("description", (Object)this.getDescription());
        json.put("properties", this.getProperties().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("functions", this.getFunctions().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("events", this.getEvents().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("tags", this.getTags().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("expands", this.getExpands());
        return json;
    }
}

