/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetlinks.core.Configurable;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.Wrapper;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingRpcSupport;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface Thing
extends Configurable,
Wrapper {
    public String getId();

    public ThingType getType();

    public Mono<? extends ThingTemplate> getTemplate();

    public Mono<Void> resetMetadata();

    public Mono<? extends ThingMetadata> getMetadata();

    public Mono<Boolean> updateMetadata(String var1);

    public Mono<Boolean> updateMetadata(ThingMetadata var1);

    public Mono<Value> getSelfConfig(String var1);

    public Mono<Values> getSelfConfigs(Collection<String> var1);

    default public Mono<Values> getSelfConfigs(String ... keys) {
        return this.getSelfConfigs(Arrays.asList(keys));
    }

    default public <V> Mono<V> getSelfConfig(ConfigKey<V> key) {
        return this.getSelfConfig(key.getKey()).map(value -> value.as(key.getValueType()));
    }

    default public Mono<Values> getSelfConfigs(ConfigKey<?> ... keys) {
        return this.getSelfConfigs(Arrays.stream(keys).map(ConfigKey::getKey).collect(Collectors.toSet()));
    }

    default public ThingRpcSupport rpc() {
        return msg -> Flux.error(UnsupportedOperationException::new);
    }
}

