/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.time.Duration;
import java.util.List;
import org.jetlinks.core.things.ThingEvent;
import org.jetlinks.core.things.ThingProperty;
import org.jetlinks.core.things.ThingTag;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.things.ThingsDataManager;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Mono;

public class BlockingThingsDataManager
implements ThingsDataManager {
    private final ThingsDataManager target;
    private final Duration timeout;

    @Override
    public Mono<ThingProperty> getLastProperty(String thingType, String thingId, String property, long baseTime) {
        return this.target.getLastProperty(thingType, thingId, property, baseTime);
    }

    public ThingProperty getLastPropertyNow(String thingType, String thingId, String property, long baseTime) {
        return this.await(this.getLastProperty(thingType, thingId, property, baseTime));
    }

    @Override
    public Mono<ThingProperty> getFirstProperty(String thingType, String thingId, String property) {
        return this.target.getFirstProperty(thingType, thingId, property);
    }

    public ThingProperty getFirstPropertyNow(String thingType, String thingId, String property) {
        return this.await(this.getFirstProperty(thingType, thingId, property));
    }

    @Override
    public Mono<Long> getLastPropertyTime(String thingType, String thingId, long baseTime) {
        return this.target.getLastPropertyTime(thingType, thingId, baseTime);
    }

    public Long getLastPropertyTimeNow(String thingType, String thingId, long baseTime) {
        return this.await(this.getLastPropertyTime(thingType, thingId, baseTime));
    }

    @Override
    public Mono<Long> getFirstPropertyTime(String thingType, String thingId) {
        return this.target.getFirstPropertyTime(thingType, thingId);
    }

    public Long getFirstPropertyTimeNow(String thingType, String thingId) {
        return this.await(this.getFirstPropertyTime(thingType, thingId));
    }

    @Override
    public Mono<List<ThingProperty>> getProperties(String thingType, String thingId, String property, long from, long to) {
        return this.target.getProperties(thingType, thingId, property, from, to);
    }

    public List<ThingProperty> getPropertiesNow(String thingType, String thingId, String property, long from, long to) {
        return this.await(this.getProperties(thingType, thingId, property, from, to));
    }

    @Override
    public Mono<List<ThingProperty>> getProperties(String thingType, String thingId, String property, long baseTime) {
        return this.target.getProperties(thingType, thingId, property, baseTime);
    }

    public List<ThingProperty> getPropertiesNow(String thingType, String thingId, String property, long baseTime) {
        return this.await(this.getProperties(thingType, thingId, property, baseTime));
    }

    @Override
    public Mono<ThingProperty> getLastProperty(ThingType thingType, String thingId, String property, long baseTime) {
        return this.target.getLastProperty(thingType, thingId, property, baseTime);
    }

    public ThingProperty getLastPropertyNow(ThingType thingType, String thingId, String property, long baseTime) {
        return this.await(this.getLastProperty(thingType, thingId, property, baseTime));
    }

    @Override
    public Mono<ThingProperty> getFirstProperty(ThingType thingType, String thingId, String property) {
        return this.target.getFirstProperty(thingType, thingId, property);
    }

    public ThingProperty getFirstPropertyNow(ThingType thingType, String thingId, String property) {
        return this.await(this.getFirstProperty(thingType, thingId, property));
    }

    @Override
    public Mono<Long> getLastPropertyTime(ThingType thingType, String thingId, long baseTime) {
        return this.target.getLastPropertyTime(thingType, thingId, baseTime);
    }

    public Long getLastPropertyTimeNow(ThingType thingType, String thingId, long baseTime) {
        return this.await(this.getLastPropertyTime(thingType, thingId, baseTime));
    }

    @Override
    public Mono<Long> getFirstPropertyTime(ThingType thingType, String thingId) {
        return this.target.getFirstPropertyTime(thingType, thingId);
    }

    public Long getFirstPropertyTimeNow(ThingType thingType, String thingId) {
        return this.await(this.getFirstPropertyTime(thingType, thingId));
    }

    @Override
    public Mono<ThingEvent> getLastEvent(String thingType, String thingId, String event, long baseTime) {
        return this.target.getLastEvent(thingType, thingId, event, baseTime);
    }

    public ThingEvent getLastEventNow(String thingType, String thingId, String event, long baseTime) {
        return this.await(this.getLastEvent(thingType, thingId, event, baseTime));
    }

    @Override
    public Mono<ThingTag> getLastTag(String thingType, String thingId, String tag, long baseTime) {
        return this.target.getLastTag(thingType, thingId, tag, baseTime);
    }

    public ThingTag getLastTagNow(String thingType, String thingId, String tag, long baseTime) {
        return this.await(this.getLastTag(thingType, thingId, tag, baseTime));
    }

    protected <T> T await(Mono<T> task) {
        return Reactors.await(task, this.timeout);
    }

    public BlockingThingsDataManager(ThingsDataManager target, Duration timeout) {
        this.target = target;
        this.timeout = timeout;
    }
}

