/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import io.netty.util.ReferenceCountUtil;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Mono;

public class LostDeviceSession
implements DeviceSession {
    private final String id;
    private final DeviceOperator operator;
    private final Transport transport;
    private final long connectTime;

    public LostDeviceSession(String id, DeviceOperator device, Transport transport) {
        this(id, device, transport, System.currentTimeMillis());
    }

    @Override
    public String getDeviceId() {
        return this.operator == null ? this.id : this.operator.getDeviceId();
    }

    @Override
    public long lastPingTime() {
        return this.connectTime;
    }

    @Override
    public long connectTime() {
        return this.connectTime;
    }

    @Override
    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        ReferenceCountUtil.safeRelease((Object)encodedMessage.getPayload());
        return Mono.error((Throwable)new DeviceOperationException.NoStackTrace(ErrorCode.CONNECTION_LOST));
    }

    @Override
    public void close() {
    }

    @Override
    public void ping() {
    }

    @Override
    public boolean isAlive() {
        return false;
    }

    @Override
    public void onClose(Runnable call) {
    }

    @Override
    public boolean isChanged(DeviceSession another) {
        return !another.isWrapFrom(LostDeviceSession.class);
    }

    @Override
    public Mono<Boolean> isAliveAsync() {
        return Reactors.ALWAYS_FALSE;
    }

    public LostDeviceSession(String id, DeviceOperator operator, Transport transport, long connectTime) {
        this.id = id;
        this.operator = operator;
        this.transport = transport;
        this.connectTime = connectTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public DeviceOperator getOperator() {
        return this.operator;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }
}

