/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.time.Duration;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.ChildrenDeviceSession;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.server.session.DeviceSessionProvider;
import org.jetlinks.core.server.session.DeviceSessionProviders;
import org.jetlinks.core.server.session.KeepOnlineSession;
import org.jetlinks.core.server.session.LostDeviceSession;
import org.jetlinks.core.server.session.PersistentSession;
import reactor.core.publisher.Mono;

class KeepOnlineDeviceSessionProvider
implements DeviceSessionProvider {
    static final String ID = "keep_online";
    static final KeepOnlineDeviceSessionProvider INSTANCE = new KeepOnlineDeviceSessionProvider();

    KeepOnlineDeviceSessionProvider() {
    }

    public static void load() {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Mono<PersistentSession> deserialize(byte[] sessionData, DeviceRegistry registry) {
        JSONObject data = (JSONObject)JSON.parseObject((byte[])sessionData, JSONObject.class, (Feature[])new Feature[0]);
        String deviceId = data.getString("deviceId");
        return registry.getDevice(deviceId).flatMap(device -> {
            String id = data.getString("id");
            String transport = data.getString("transport");
            long timeout = data.getLongValue("timeout");
            long lstTime = data.getLongValue("lstTime");
            boolean children = data.getBooleanValue("children");
            String parentProvider = data.getString("parentProvider");
            byte[] parent = data.getBytes("parent");
            Mono sessionMono = parentProvider != null && parent != null ? Mono.justOrEmpty(DeviceSessionProvider.lookup(parentProvider)).flatMap(provider -> provider.deserialize(parent, registry)) : Mono.empty();
            if (children) {
                sessionMono = sessionMono.flatMap(session -> device.getSelfConfig(DeviceConfigKey.parentGatewayId).flatMap(registry::getDevice).map(parentDevice -> new ChildrenDeviceSession(id, (DeviceSession)session, (DeviceOperator)parentDevice)));
            }
            return sessionMono.switchIfEmpty(Mono.fromSupplier(() -> new LostDeviceSession(id, (DeviceOperator)device, Transport.of(transport)))).map(_parent -> {
                KeepOnlineSession session = new KeepOnlineSession((DeviceSession)_parent, Duration.ofMillis(timeout));
                session.setLastKeepAliveTime(lstTime);
                session.setIgnoreParent(data.getBooleanValue("ignoreParent"));
                return session;
            });
        });
    }

    @Override
    public Mono<byte[]> serialize(PersistentSession session, DeviceRegistry registry) {
        KeepOnlineSession keepOnlineSession = session.unwrap(KeepOnlineSession.class);
        JSONObject data = new JSONObject();
        data.put("id", (Object)session.getId());
        data.put("deviceId", (Object)session.getDeviceId());
        data.put("timeout", (Object)session.getKeepAliveTimeout().toMillis());
        data.put("lstTime", (Object)session.lastPingTime());
        data.put("transport", (Object)session.getTransport().getId());
        data.put("ignoreParent", (Object)keepOnlineSession.isIgnoreParent());
        data.put("children", (Object)session.isWrapFrom(ChildrenDeviceSession.class));
        DeviceSession parent = keepOnlineSession.getParent();
        if (parent.isWrapFrom(PersistentSession.class)) {
            PersistentSession persistentSession = parent.unwrap(PersistentSession.class);
            return Mono.justOrEmpty(DeviceSessionProvider.lookup(persistentSession.getProvider())).flatMap(provider -> provider.serialize(persistentSession, registry).doOnNext(bytes -> {
                data.put("parentProvider", (Object)provider.getId());
                data.put("parent", bytes);
            })).then(Mono.fromCallable(() -> JSON.toJSONBytes((Object)data, (SerializerFeature[])new SerializerFeature[0])));
        }
        return Mono.just((Object)JSON.toJSONBytes((Object)data, (SerializerFeature[])new SerializerFeature[0]));
    }

    static {
        DeviceSessionProviders.register(INSTANCE);
    }
}

