/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.monitor.logger;

import org.jetlinks.core.monitor.logger.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;

public interface Slf4jMarkerLogger
extends Logger {
    public org.slf4j.Logger getLogger();

    public Marker getMarker();

    @Override
    default public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.getLogger().isTraceEnabled(this.getMarker());
            }
            case DEBUG: {
                return this.getLogger().isDebugEnabled(this.getMarker());
            }
            case INFO: {
                return this.getLogger().isInfoEnabled(this.getMarker());
            }
            case WARN: {
                return this.getLogger().isWarnEnabled(this.getMarker());
            }
            case ERROR: {
                return this.getLogger().isErrorEnabled(this.getMarker());
            }
        }
        return false;
    }

    @Override
    default public void log(Level level, String message, Object ... args) {
        switch (level) {
            case TRACE: {
                this.getLogger().trace(this.getMarker(), message, args);
                return;
            }
            case DEBUG: {
                this.getLogger().debug(this.getMarker(), message, args);
                return;
            }
            case INFO: {
                this.getLogger().info(this.getMarker(), message, args);
                return;
            }
            case WARN: {
                this.getLogger().warn(this.getMarker(), message, args);
                return;
            }
            case ERROR: {
                this.getLogger().error(this.getMarker(), message, args);
            }
        }
    }
}

