/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;
import org.jetlinks.core.metadata.types.ISODateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeType
extends AbstractType<DateTimeType>
implements DataType,
Converter<Date> {
    private static final Logger log = LoggerFactory.getLogger(DateTimeType.class);
    public static final String ID = "date";
    public static final String TIMESTAMP_FORMAT = "timestamp";
    public static final DateTimeType GLOBAL = new DateTimeType();
    private String format = "timestamp";
    private ZoneId zoneId = ZoneId.systemDefault();
    private DateTimeFormatter formatter;

    public DateTimeType timeZone(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public DateTimeType format(String format) {
        this.format = format;
        this.getFormatter();
        return this;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return LocaleUtils.resolveMessage((String)"message.metadata.type.date", (Locale)LocaleUtils.current(), (String)"\u65f6\u95f4", (Object[])new Object[0]);
    }

    protected DateTimeFormatter getFormatter() {
        if (this.formatter == null && !TIMESTAMP_FORMAT.equals(this.format)) {
            this.formatter = DateTimeFormatter.ofPattern(this.format);
        }
        return this.formatter;
    }

    @Override
    public ValidateResult validate(Object value) {
        if ((value = this.convert(value)) == null) {
            return ValidateResult.fail("\u4e0d\u662f\u5408\u6cd5\u7684\u65f6\u95f4\u683c\u5f0f");
        }
        return ValidateResult.success(value);
    }

    @Override
    public String format(Object value) {
        try {
            if (TIMESTAMP_FORMAT.equals(this.format)) {
                return String.valueOf(this.convert(value).getTime());
            }
            Date dateValue = this.convert(value);
            if (dateValue == null) {
                return "";
            }
            return LocalDateTime.ofInstant(dateValue.toInstant(), this.zoneId).format(this.getFormatter());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public Date convert(Object value) {
        if (value instanceof Instant) {
            return Date.from((Instant)value);
        }
        if (value instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)value).atZone(this.zoneId).toInstant());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            if (StringUtils.isNumber((Object)value)) {
                return new Date(Long.parseLong((String)value));
            }
            Date data = DateFormatter.fromString((String)((String)value));
            if (data != null) {
                return data;
            }
            DateTimeFormatter formatter = this.getFormatter();
            if (null == formatter) {
                throw new IllegalArgumentException("unsupported date format:" + value);
            }
            return Date.from(LocalDateTime.parse((String)value, formatter).atZone(this.zoneId).toInstant());
        }
        throw new IllegalArgumentException("can not format datetime :" + value);
    }

    public String getFormat() {
        return this.format;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    static {
        DateFormatter.supportFormatter.add(new ISODateTimeFormatter());
    }
}

