/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.MergeOption;
import org.jetlinks.core.metadata.PropertyMetadata;

public class SimpleFunctionMetadata
implements FunctionMetadata {
    private String id;
    private String name;
    private String description;
    private Map<String, Object> expands;
    private List<PropertyMetadata> inputs;
    private DataType output;
    private boolean async;

    public static SimpleFunctionMetadata of(String id, String name, List<PropertyMetadata> inputs, DataType output) {
        return SimpleFunctionMetadata.of(id, name, null, null, inputs, output, false);
    }

    public SimpleFunctionMetadata copy() {
        return SimpleFunctionMetadata.of(this.id, this.name, this.description, this.expands == null ? null : new HashMap<String, Object>(this.expands), new ArrayList<PropertyMetadata>(this.inputs), this.output, this.async);
    }

    @Override
    public <T> SimpleFunctionMetadata expand(ConfigKey<T> key, T value) {
        return this.expand(key.getKey(), value);
    }

    @Override
    public synchronized SimpleFunctionMetadata expand(String key, Object value) {
        if (this.expands == null) {
            this.expands = new HashMap<String, Object>();
        } else if (!(this.expands instanceof HashMap)) {
            this.expands = Maps.newHashMap(this.expands);
        }
        this.expands.put(key, value);
        return this;
    }

    @Override
    @Nonnull
    public List<PropertyMetadata> getInputs() {
        if (this.inputs == null) {
            return Collections.emptyList();
        }
        return this.inputs;
    }

    @Override
    public FunctionMetadata merge(FunctionMetadata another, MergeOption ... option) {
        return another;
    }

    public String toString() {
        return (this.output == null ? "void" : this.output) + " " + this.id + "(" + (CollectionUtils.isEmpty(this.inputs) ? "" : this.inputs) + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, Object> getExpands() {
        return this.expands;
    }

    @Override
    public DataType getOutput() {
        return this.output;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }

    public void setInputs(List<PropertyMetadata> inputs) {
        this.inputs = inputs;
    }

    public void setOutput(DataType output) {
        this.output = output;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    private SimpleFunctionMetadata(String id, String name, String description, Map<String, Object> expands, List<PropertyMetadata> inputs, DataType output, boolean async) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.expands = expands;
        this.inputs = inputs;
        this.output = output;
        this.async = async;
    }

    public static SimpleFunctionMetadata of(String id, String name, String description, Map<String, Object> expands, List<PropertyMetadata> inputs, DataType output, boolean async) {
        return new SimpleFunctionMetadata(id, name, description, expands, inputs, output, async);
    }

    public SimpleFunctionMetadata() {
    }
}

