/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.utils.MetadataUtils;

public interface Metadata
extends Serializable {
    public String getId();

    public String getName();

    default public String getI18nName() {
        return MetadataUtils.resolveI18nMessage(LocaleUtils.current(), this, "name", this.getName());
    }

    public String getDescription();

    public Map<String, Object> getExpands();

    default public Optional<Object> getExpand(String key) {
        return Optional.ofNullable(this.getExpands()).map(map -> map.get(key));
    }

    default public <T> Optional<T> getExpand(ConfigKey<T> key) {
        return Optional.ofNullable(this.getExpands()).map(map -> map.get(key.getKey())).map(key::convertValue);
    }

    default public void setExpands(Map<String, Object> expands) {
    }

    default public void setName(String name) {
    }

    default public void setDescription(String description) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Metadata expand(String key, Object value) {
        Metadata metadata = this;
        synchronized (metadata) {
            HashMap expands = this.getExpands();
            if (expands == null) {
                expands = new HashMap<String, Object>();
            } else if (!(expands instanceof HashMap)) {
                expands = Maps.newHashMap(expands);
            }
            expands.put(key, value);
            this.setExpands(expands);
        }
        return this;
    }

    default public <T> Metadata expand(ConfigKey<T> key, T value) {
        return this.expand(key.getKey(), value);
    }
}

