/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigKeyValue;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;
import org.jetlinks.core.metadata.ConfigScope;
import org.jetlinks.core.metadata.DataType;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;

public class DefaultConfigMetadata
implements ConfigMetadata {
    private static final long serialVersionUID = 0L;
    private String name;
    private String description;
    private String document;
    private ConfigScope[] scopes;
    private List<ConfigPropertyMetadata> properties = new ArrayList<ConfigPropertyMetadata>();

    public DefaultConfigMetadata() {
    }

    public DefaultConfigMetadata(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public DefaultConfigMetadata(String name, String description, Resource document) {
        this.name = name;
        this.description = description;
        try (InputStream doc = document.getInputStream();){
            this.document = StreamUtils.copyToString((InputStream)doc, (Charset)StandardCharsets.UTF_8);
        }
    }

    @Override
    public ConfigScope[] getScopes() {
        return this.scopes == null ? ConfigMetadata.super.getScopes() : this.scopes;
    }

    @Override
    public List<ConfigPropertyMetadata> getProperties() {
        return this.properties;
    }

    public DefaultConfigMetadata scope(ConfigScope ... scopes) {
        this.scopes = scopes;
        return this;
    }

    public DefaultConfigMetadata add(ConfigPropertyMetadata metadata) {
        this.properties.add(metadata);
        return this;
    }

    public DefaultConfigMetadata add(String property, String name, DataType type, Consumer<Property> custom) {
        Property prop = Property.of(property, name, this.description, type, all, null);
        custom.accept(prop);
        return this.add(prop);
    }

    public DefaultConfigMetadata add(String property, String name, DataType type) {
        return this.add(property, name, null, type);
    }

    public DefaultConfigMetadata add(String property, String name, String description, DataType type) {
        return this.add(Property.of(property, name, description, type, all, null));
    }

    public DefaultConfigMetadata add(String property, String name, DataType type, ConfigScope ... scopes) {
        return this.add(property, name, null, type, scopes);
    }

    public DefaultConfigMetadata add(String property, String name, String description, DataType type, ConfigScope ... scopes) {
        return this.add(Property.of(property, name, description, type, scopes, null));
    }

    @Override
    public DefaultConfigMetadata copy(ConfigScope ... scopes) {
        DefaultConfigMetadata configMetadata = new DefaultConfigMetadata(this.name, this.description);
        configMetadata.scopes = this.scopes;
        configMetadata.properties = scopes == null || scopes.length == 0 ? new ArrayList<ConfigPropertyMetadata>(this.properties) : this.properties.stream().filter(conf -> conf.hasAnyScope(scopes)).collect(Collectors.toList());
        return configMetadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getDocument() {
        return this.document;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public void setScopes(ConfigScope[] scopes) {
        this.scopes = scopes;
    }

    public void setProperties(List<ConfigPropertyMetadata> properties) {
        this.properties = properties;
    }

    public static class Property
    implements ConfigPropertyMetadata {
        private static final long serialVersionUID = 0L;
        private String property;
        private String name;
        private String description;
        private DataType type;
        private ConfigScope[] scopes;
        private Map<String, Object> expands;

        public Property description(String description) {
            this.description = description;
            return this;
        }

        public Property scope(ConfigScope ... scopes) {
            this.scopes = scopes;
            return this;
        }

        public Property expands(Map<String, Object> expands) {
            if (CollectionUtils.isEmpty(expands)) {
                return this;
            }
            if (this.expands == null) {
                this.expands = new HashMap<String, Object>();
            } else if (!(this.expands instanceof HashMap)) {
                this.expands = Maps.newHashMap(this.expands);
            }
            this.expands.putAll(expands);
            return this;
        }

        public Property expand(ConfigKeyValue<?> ... kvs) {
            for (ConfigKeyValue<?> kv : kvs) {
                this.expand(kv.getKey(), kv.getValue());
            }
            return this;
        }

        public <V> Property expand(ConfigKey<V> configKey, V value) {
            return this.expand(configKey.getKey(), value);
        }

        public Property expand(String configKey, Object value) {
            if (value == null) {
                return this;
            }
            if (this.expands == null) {
                this.expands = new HashMap<String, Object>();
            } else if (!(this.expands instanceof HashMap)) {
                this.expands = Maps.newHashMap(this.expands);
            }
            this.expands.put(configKey, value);
            return this;
        }

        public static PropertyBuilder builder() {
            return new PropertyBuilder();
        }

        @Override
        public String getProperty() {
            return this.property;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public DataType getType() {
            return this.type;
        }

        @Override
        public ConfigScope[] getScopes() {
            return this.scopes;
        }

        @Override
        public Map<String, Object> getExpands() {
            return this.expands;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setType(DataType type) {
            this.type = type;
        }

        public void setScopes(ConfigScope[] scopes) {
            this.scopes = scopes;
        }

        public void setExpands(Map<String, Object> expands) {
            this.expands = expands;
        }

        public Property() {
        }

        private Property(String property, String name, String description, DataType type, ConfigScope[] scopes, Map<String, Object> expands) {
            this.property = property;
            this.name = name;
            this.description = description;
            this.type = type;
            this.scopes = scopes;
            this.expands = expands;
        }

        public static Property of(String property, String name, String description, DataType type, ConfigScope[] scopes, Map<String, Object> expands) {
            return new Property(property, name, description, type, scopes, expands);
        }

        public static class PropertyBuilder {
            private String property;
            private String name;
            private String description;
            private DataType type;
            private ConfigScope[] scopes;
            private Map<String, Object> expands;

            PropertyBuilder() {
            }

            public PropertyBuilder property(String property) {
                this.property = property;
                return this;
            }

            public PropertyBuilder name(String name) {
                this.name = name;
                return this;
            }

            public PropertyBuilder description(String description) {
                this.description = description;
                return this;
            }

            public PropertyBuilder type(DataType type) {
                this.type = type;
                return this;
            }

            public PropertyBuilder scopes(ConfigScope[] scopes) {
                this.scopes = scopes;
                return this;
            }

            public PropertyBuilder expands(Map<String, Object> expands) {
                this.expands = expands;
                return this;
            }

            public Property build() {
                return new Property(this.property, this.name, this.description, this.type, this.scopes, this.expands);
            }

            public String toString() {
                return "DefaultConfigMetadata.Property.PropertyBuilder(property=" + this.property + ", name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", scopes=" + Arrays.deepToString(this.scopes) + ", expands=" + this.expands + ")";
            }
        }
    }
}

