/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata;

import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.MergeOption;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.utils.CompositeList;
import org.jetlinks.core.utils.CompositeMap;

public class CompositeThingMetadata
implements ThingMetadata {
    protected final ThingMetadata left;
    protected final ThingMetadata right;

    public ThingMetadata left() {
        return this.left;
    }

    public ThingMetadata right() {
        return this.right;
    }

    @Override
    public List<PropertyMetadata> getProperties() {
        return new CompositeList<PropertyMetadata>(this.left.getProperties(), new ArrayList(Collections2.filter(this.right.getProperties(), prop -> this.left.getPropertyOrNull(prop.getId()) == null)));
    }

    @Override
    public List<FunctionMetadata> getFunctions() {
        return new CompositeList<FunctionMetadata>(this.left.getFunctions(), new ArrayList(Collections2.filter(this.right.getFunctions(), prop -> this.left.getFunctionOrNull(prop.getId()) == null)));
    }

    @Override
    public List<EventMetadata> getEvents() {
        return new CompositeList<EventMetadata>(this.left.getEvents(), new ArrayList(Collections2.filter(this.right.getEvents(), prop -> this.left.getEventOrNull(prop.getId()) == null)));
    }

    @Override
    public List<PropertyMetadata> getTags() {
        return new CompositeList<PropertyMetadata>(this.left.getTags(), new ArrayList(Collections2.filter(this.right.getTags(), prop -> this.left.getTagOrNull(prop.getId()) == null)));
    }

    @Override
    public EventMetadata getEventOrNull(String id) {
        EventMetadata metadata = this.left.getEventOrNull(id);
        if (metadata != null) {
            return metadata;
        }
        return this.right.getEventOrNull(id);
    }

    @Override
    public PropertyMetadata getPropertyOrNull(String id) {
        PropertyMetadata metadata = this.left.getPropertyOrNull(id);
        if (metadata != null) {
            return metadata;
        }
        return this.right.getPropertyOrNull(id);
    }

    @Override
    public FunctionMetadata getFunctionOrNull(String id) {
        FunctionMetadata metadata = this.left.getFunctionOrNull(id);
        if (metadata != null) {
            return metadata;
        }
        return this.right.getFunctionOrNull(id);
    }

    @Override
    public PropertyMetadata getTagOrNull(String id) {
        PropertyMetadata metadata = this.left.getTagOrNull(id);
        if (metadata != null) {
            return metadata;
        }
        return this.right.getTagOrNull(id);
    }

    @Override
    public String getId() {
        return this.left.getId();
    }

    @Override
    public String getName() {
        return this.left.getName();
    }

    @Override
    public String getDescription() {
        return this.left.getDescription();
    }

    @Override
    public Map<String, Object> getExpands() {
        if (this.left.getExpands() == null) {
            return this.right.getExpands();
        }
        if (this.right.getExpands() == null) {
            return this.left.getExpands();
        }
        return new CompositeMap<String, Object>(this.left.getExpands(), this.right.getExpands());
    }

    @Override
    public <T extends ThingMetadata> CompositeThingMetadata merge(T metadata) {
        return this.merge((ThingMetadata)metadata, MergeOption.DEFAULT_OPTIONS);
    }

    @Override
    public <T extends ThingMetadata> CompositeThingMetadata merge(T metadata, MergeOption ... options) {
        return new CompositeThingMetadata(this.left.merge(metadata, options), this.right);
    }

    public CompositeThingMetadata(ThingMetadata left, ThingMetadata right) {
        this.left = left;
        this.right = right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositeThingMetadata)) {
            return false;
        }
        CompositeThingMetadata other = (CompositeThingMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ThingMetadata this$left = this.left;
        ThingMetadata other$left = other.left;
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        ThingMetadata this$right = this.right;
        ThingMetadata other$right = other.right;
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompositeThingMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThingMetadata $left = this.left;
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        ThingMetadata $right = this.right;
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }
}

