/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableThingMessage;
import org.jetlinks.core.message.property.WriteThingPropertyMessageReply;
import org.jetlinks.core.utils.SerializeUtils;

public interface WriteThingPropertyMessage<T extends WriteThingPropertyMessageReply>
extends RepayableThingMessage<T> {
    public Map<String, Object> getProperties();

    public void addProperty(String var1, Object var2);

    @Override
    default public MessageType getMessageType() {
        return MessageType.READ_PROPERTY;
    }

    @Override
    default public MessageType getReplyType() {
        return MessageType.READ_PROPERTY_REPLY;
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        RepayableThingMessage.super.writeExternal(out);
        SerializeUtils.writeKeyValue(this.getProperties(), out);
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        RepayableThingMessage.super.readExternal(in);
        SerializeUtils.readKeyValue(in, this::addProperty);
    }
}

