/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableThingMessage;
import org.jetlinks.core.message.function.DefaultFunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionParameter;
import org.jetlinks.core.message.function.ThingFunctionInvokeMessageReply;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.utils.SerializeUtils;

public interface ThingFunctionInvokeMessage<R extends ThingFunctionInvokeMessageReply>
extends RepayableThingMessage<R> {
    public String getFunctionId();

    public List<FunctionParameter> getInputs();

    public ThingFunctionInvokeMessage<R> addInput(FunctionParameter var1);

    default public ThingFunctionInvokeMessage<R> addInput(String name, Object value) {
        return this.addInput(new FunctionParameter(name, value));
    }

    default public ThingFunctionInvokeMessage<R> addInputs(Map<String, Object> parameters) {
        parameters.forEach(this::addInput);
        return this;
    }

    public ThingFunctionInvokeMessage<R> functionId(String var1);

    @Override
    public R newReply();

    @Override
    default public MessageType getMessageType() {
        return MessageType.INVOKE_FUNCTION;
    }

    @Override
    default public MessageType getReplyType() {
        return MessageType.INVOKE_FUNCTION_REPLY;
    }

    default public Optional<Object> getInput(String name) {
        for (FunctionParameter input : this.getInputs()) {
            if (!Objects.equals(name, input.getName())) continue;
            return Optional.ofNullable(input.getValue());
        }
        return Optional.empty();
    }

    default public Optional<Object> getInput(int index) {
        List<FunctionParameter> inputs = this.getInputs();
        return inputs != null && inputs.size() > index ? Optional.ofNullable(inputs.get(index)) : Optional.empty();
    }

    default public Map<String, Object> inputsToMap() {
        List<FunctionParameter> inputs = this.getInputs();
        if (CollectionUtils.isEmpty(inputs)) {
            return Collections.emptyMap();
        }
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)inputs.size());
        for (FunctionParameter input : inputs) {
            map.put(input.getName(), input.getValue());
        }
        return map;
    }

    default public <T> T inputsToBean(Class<T> beanType) {
        return (T)new JSONObject(this.inputsToMap()).toJavaObject(beanType);
    }

    default public List<Object> inputsToList() {
        return this.getInputs().stream().map(FunctionParameter::getValue).collect(Collectors.toList());
    }

    default public Object[] inputsToArray() {
        return this.getInputs().stream().map(FunctionParameter::getValue).toArray();
    }

    public static FunctionInvokeMessage forDevice(String deviceId) {
        FunctionInvokeMessage message = new FunctionInvokeMessage();
        message.setDeviceId(deviceId);
        return message;
    }

    public static DefaultFunctionInvokeMessage forThing(ThingType thingType, String deviceId) {
        DefaultFunctionInvokeMessage message = new DefaultFunctionInvokeMessage();
        message.setThingId(deviceId);
        message.setThingType(thingType.getId());
        return message;
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        RepayableThingMessage.super.writeExternal(out);
        SerializeUtils.writeNullableUTF(this.getFunctionId(), out);
        SerializeUtils.writeKeyValue(this.getInputs(), FunctionParameter::getName, FunctionParameter::getValue, out);
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        RepayableThingMessage.super.readExternal(in);
        this.functionId(SerializeUtils.readNullableUTF(in));
        SerializeUtils.readKeyValue(in, this::addInput);
    }
}

