/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.function;

import com.alibaba.fastjson.JSONObject;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.function.ThingFunctionInvokeMessageReply;

public class FunctionInvokeMessageReply
extends CommonDeviceMessageReply<FunctionInvokeMessageReply>
implements ThingFunctionInvokeMessageReply {
    private String functionId;
    private Object output;

    @Override
    public MessageType getMessageType() {
        return MessageType.INVOKE_FUNCTION_REPLY;
    }

    public static FunctionInvokeMessageReply create() {
        FunctionInvokeMessageReply reply = new FunctionInvokeMessageReply();
        reply.setTimestamp(System.currentTimeMillis());
        return reply;
    }

    @Override
    public FunctionInvokeMessageReply success() {
        this.setSuccess(true);
        return this;
    }

    public FunctionInvokeMessageReply success(Object output) {
        return this.success().output(output);
    }

    @Override
    public FunctionInvokeMessageReply output(Object output) {
        this.setOutput(output);
        return this;
    }

    @Override
    public FunctionInvokeMessageReply functionId(String functionId) {
        this.functionId = functionId;
        return this;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.functionId = jsonObject.getString("functionId");
        this.output = jsonObject.get((Object)"output");
    }

    public static FunctionInvokeMessageReply success(String deviceId, String functionId, String messageId, Object output) {
        FunctionInvokeMessageReply reply = new FunctionInvokeMessageReply();
        reply.setFunctionId(functionId);
        reply.setOutput(output);
        reply.success();
        reply.setDeviceId(deviceId);
        reply.setMessageId(messageId);
        return reply;
    }

    public static FunctionInvokeMessageReply error(String deviceId, String functionId, String messageId, String message) {
        FunctionInvokeMessageReply reply = new FunctionInvokeMessageReply();
        reply.setFunctionId(functionId);
        reply.setMessage(message);
        reply.setSuccess(false);
        reply.setDeviceId(deviceId);
        reply.setMessageId(messageId);
        return reply;
    }

    @Override
    public String getFunctionId() {
        return this.functionId;
    }

    @Override
    public Object getOutput() {
        return this.output;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public void setOutput(Object output) {
        this.output = output;
    }
}

