/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.function.FunctionParameter;
import org.jetlinks.core.message.function.ThingFunctionInvokeMessage;

public class FunctionInvokeMessage
extends CommonDeviceMessage<FunctionInvokeMessage>
implements RepayableDeviceMessage<FunctionInvokeMessageReply>,
ThingFunctionInvokeMessage<FunctionInvokeMessageReply> {
    private String functionId;
    private List<FunctionParameter> inputs = new ArrayList<FunctionParameter>();

    public FunctionInvokeMessage functionId(String id) {
        this.functionId = id;
        return this;
    }

    public FunctionInvokeMessage addInput(FunctionParameter parameter) {
        this.inputs.add(parameter);
        return this;
    }

    public FunctionInvokeMessage addInput(String name, Object value) {
        ThingFunctionInvokeMessage.super.addInput(name, value);
        return this;
    }

    public FunctionInvokeMessage addInputs(Map<String, Object> parameters) {
        ThingFunctionInvokeMessage.super.addInputs(parameters);
        return this;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.functionId = jsonObject.getString("functionId");
        Object inputs = jsonObject.get((Object)"inputs");
        if (inputs instanceof Map) {
            super.fromJson(new JSONObject(Maps.filterKeys((Map)jsonObject, key -> !"inputs".equals(key))));
            Map inputMap = (Map)inputs;
            inputMap.forEach(this::addInput);
            return;
        }
        super.fromJson(jsonObject);
    }

    @Override
    public FunctionInvokeMessageReply newReply() {
        FunctionInvokeMessageReply reply = (FunctionInvokeMessageReply)new FunctionInvokeMessageReply().from(this);
        reply.setFunctionId(this.functionId);
        return reply;
    }

    @Override
    public String getFunctionId() {
        return this.functionId;
    }

    @Override
    public List<FunctionParameter> getInputs() {
        return this.inputs;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public void setInputs(List<FunctionParameter> inputs) {
        this.inputs = inputs;
    }
}

