/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.firmware;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.utils.SerializeUtils;

public class UpgradeFirmwareProgressMessage
extends CommonDeviceMessage<UpgradeFirmwareProgressMessage> {
    private int progress;
    private boolean complete;
    private String version;
    private boolean success;
    private String errorReason;
    private String firmwareId;

    public UpgradeFirmwareProgressMessage success(int progress) {
        this.setSuccess(true);
        this.setProgress(progress);
        return this;
    }

    public UpgradeFirmwareProgressMessage complete() {
        this.setComplete(true);
        return this.success(100);
    }

    public UpgradeFirmwareProgressMessage error(Throwable e) {
        this.setSuccess(false);
        this.setErrorReason(e.getMessage());
        return this;
    }

    public UpgradeFirmwareProgressMessage error(String reason) {
        this.setSuccess(false);
        this.setErrorReason(reason);
        return this;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.UPGRADE_FIRMWARE_PROGRESS;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.progress);
        out.writeBoolean(this.complete);
        out.writeBoolean(this.success);
        SerializeUtils.writeNullableUTF(this.version, out);
        SerializeUtils.writeNullableUTF(this.errorReason, out);
        SerializeUtils.writeNullableUTF(this.firmwareId, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.progress = in.readInt();
        this.complete = in.readBoolean();
        this.success = in.readBoolean();
        this.version = SerializeUtils.readNullableUTF(in);
        this.errorReason = SerializeUtils.readNullableUTF(in);
        this.firmwareId = SerializeUtils.readNullableUTF(in);
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public String getFirmwareId() {
        return this.firmwareId;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setErrorReason(String errorReason) {
        this.errorReason = errorReason;
    }

    public void setFirmwareId(String firmwareId) {
        this.firmwareId = firmwareId;
    }
}

