/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.collector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.message.collector.ReadCollectorDataMessageReply;
import org.springframework.util.CollectionUtils;

public final class ReadCollectorDataMessage
extends CommonDeviceMessage<ReadCollectorDataMessage>
implements RepayableDeviceMessage<ReadCollectorDataMessageReply> {
    private List<String> addresses;

    @Override
    public MessageType getMessageType() {
        return MessageType.READ_COLLECTOR_DATA;
    }

    @Override
    public MessageType getReplyType() {
        return MessageType.READ_COLLECTOR_DATA_REPLY;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (CollectionUtils.isEmpty(this.addresses)) {
            out.writeInt(0);
        } else {
            out.writeInt(this.addresses.size());
            for (String datum : this.addresses) {
                out.writeUTF(datum);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        this.addresses = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            this.addresses.add(in.readUTF());
        }
    }

    @Override
    public ReadCollectorDataMessageReply newReply() {
        return new ReadCollectorDataMessageReply();
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }
}

