/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.message.codec.http.FilePart;
import org.jetlinks.core.message.codec.http.FormFieldPart;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.jetlinks.core.message.codec.http.Part;
import org.jetlinks.core.message.codec.http.SimplePart;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.DefaultPartHttpMessageReader;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class MultiPartParser {
    private static final MultipartHttpMessageReader reader;
    private static final NettyDataBufferFactory factory;
    private static final ResolvableType type;

    MultiPartParser() {
    }

    static Mono<MultiPart> parser(HttpHeaders httpHeaders, Flux<ByteBuf> data) {
        return reader.read(type, (ReactiveHttpInputMessage)new MultiPartParserReactiveHttpInputMessage(data, httpHeaders), Collections.emptyMap()).flatMapIterable(Map::entrySet).flatMapIterable(Map.Entry::getValue).flatMap(part -> part.content().map(buf -> factory.wrap(buf.asByteBuffer())).collectList().filter(CollectionUtils::isNotEmpty).map(arg_0 -> ((NettyDataBufferFactory)factory).join(arg_0)).cast(NettyDataBuffer.class).map(buffer -> MultiPartParser.convertPart(part, buffer.getNativeBuffer()))).collectList().filter(CollectionUtils::isNotEmpty).map(MultiPart::of);
    }

    private static Part convertPart(org.springframework.http.codec.multipart.Part part, ByteBuf byteBuf) {
        if (part instanceof org.springframework.http.codec.multipart.FilePart) {
            org.springframework.http.codec.multipart.FilePart filePart = (org.springframework.http.codec.multipart.FilePart)part;
            return FilePart.of(filePart.name(), filePart.filename(), filePart.headers(), byteBuf);
        }
        if (part instanceof org.springframework.http.codec.multipart.FormFieldPart) {
            org.springframework.http.codec.multipart.FormFieldPart formFieldPart = (org.springframework.http.codec.multipart.FormFieldPart)part;
            return FormFieldPart.of(formFieldPart.name(), formFieldPart.value(), formFieldPart.headers(), byteBuf);
        }
        return new SimplePart(part.name(), part.headers(), byteBuf);
    }

    static {
        factory = new NettyDataBufferFactory((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        type = ResolvableType.forType(Part.class);
        DefaultPartHttpMessageReader messageReader = new DefaultPartHttpMessageReader();
        messageReader.setMaxInMemorySize(-1);
        reader = new MultipartHttpMessageReader((HttpMessageReader)messageReader);
    }

    static class MultiPartParserReactiveHttpInputMessage
    implements ReactiveHttpInputMessage {
        private final Flux<ByteBuf> data;
        private final HttpHeaders headers;

        @Nonnull
        public Flux<DataBuffer> getBody() {
            return this.data.map(arg_0 -> ((NettyDataBufferFactory)factory).wrap(arg_0));
        }

        @Nonnull
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public MultiPartParserReactiveHttpInputMessage(Flux<ByteBuf> data, HttpHeaders headers) {
            this.data = data;
            this.headers = headers;
        }
    }
}

