/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.message.codec.http.HttpRequestMessage;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.jetlinks.core.message.codec.http.SimpleHttpExchangeMessage;
import org.jetlinks.core.message.codec.http.SimpleHttpResponseMessage;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public interface HttpExchangeMessage
extends HttpRequestMessage {
    public static HttpExchangeMessage create(HttpRequestMessage request, Function<HttpResponseMessage, Mono<Void>> responseHandler) {
        return new SimpleHttpExchangeMessage(request, responseHandler);
    }

    default public Mono<ByteBuf> payload() {
        return Mono.just((Object)this.getPayload());
    }

    default public Mono<MultiPart> multiPartAsync() {
        return this.payload().then(Mono.defer(() -> Mono.justOrEmpty(HttpRequestMessage.super.multiPart())));
    }

    @Override
    @Deprecated
    default public Optional<MultiPart> multiPart() {
        return HttpRequestMessage.super.multiPart();
    }

    @Override
    @Nullable
    @Deprecated
    default public Map<String, String> getRequestParam() {
        return HttpRequestMessage.super.getRequestParam();
    }

    default public Mono<Map<String, String>> getRequestParamAsync() {
        return this.payload().mapNotNull(buf -> HttpRequestMessage.super.getRequestParam());
    }

    @Override
    @Nonnull
    @Deprecated
    public ByteBuf getPayload();

    @Nonnull
    public Mono<Void> response(@Nonnull HttpResponseMessage var1);

    default public Mono<Void> ok(@Nonnull String message) {
        return this.response(SimpleHttpResponseMessage.builder().contentType(MediaType.APPLICATION_JSON).status(200).body(message).build());
    }

    default public Mono<Void> error(int status, @Nonnull String message) {
        return this.response(SimpleHttpResponseMessage.builder().contentType(MediaType.APPLICATION_JSON).status(status).body(message).build());
    }

    default public SimpleHttpResponseMessage.SimpleHttpResponseMessageBuilder newResponse() {
        return SimpleHttpResponseMessage.builder();
    }
}

