/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.utils.SerializeUtils;

public interface ThingMessageReply
extends ThingMessage {
    public boolean isSuccess();

    @Nullable
    public String getCode();

    @Nullable
    public String getMessage();

    default public ThingMessageReply error(String errorCode, String msg) {
        return this.success(false).code(errorCode).message(msg);
    }

    public ThingMessageReply error(ErrorCode var1);

    default public ThingMessageReply error(Throwable e) {
        return this.success(false).error(ErrorCode.of(e)).message(e.getMessage()).addHeader("errorType", (Object)e.getClass().getName()).addHeader("errorMessage", (Object)e.getMessage());
    }

    @Override
    public ThingMessageReply thingId(@Nonnull String var1, @Nonnull String var2);

    public ThingMessageReply success();

    public ThingMessageReply success(boolean var1);

    public ThingMessageReply code(@Nonnull String var1);

    public ThingMessageReply message(@Nonnull String var1);

    public ThingMessageReply from(@Nonnull Message var1);

    @Override
    public ThingMessageReply messageId(@Nonnull String var1);

    @Override
    public ThingMessageReply timestamp(long var1);

    @Override
    public ThingMessageReply addHeader(@Nonnull String var1, @Nonnull Object var2);

    @Override
    default public <T> ThingMessageReply addHeader(@Nonnull HeaderKey<T> header, @Nonnull T value) {
        this.addHeader(header.getKey(), value);
        return this;
    }

    @Override
    default public ThingMessageReply copy() {
        return (ThingMessageReply)ThingMessage.super.copy();
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        ThingMessage.super.writeExternal(out);
        out.writeBoolean(this.isSuccess());
        SerializeUtils.writeNullableUTF(this.getCode(), out);
        SerializeUtils.writeNullableUTF(this.getMessage(), out);
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ThingMessage.super.readExternal(in);
        this.success(in.readBoolean());
        this.code(SerializeUtils.readNullableUTF(in));
        this.message(SerializeUtils.readNullableUTF(in));
    }

    default public void assertSuccess() throws DeviceOperationException {
        if (!this.isSuccess()) {
            throw new DeviceOperationException.NoStackTrace(ErrorCode.of(this.getCode()).orElse(ErrorCode.UNKNOWN), this.getMessage());
        }
    }
}

