/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.util.concurrent.TimeUnit;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Message;

public interface Headers {
    public static final HeaderKey<Boolean> force = HeaderKey.of("force", true, Boolean.class);
    public static final HeaderKey<Boolean> keepOnline = HeaderKey.of("keepOnline", true, Boolean.class);
    public static final HeaderKey<Boolean> keepOnlineIgnoreConnection = HeaderKey.of("keepOnlineIC", false, Boolean.class);
    public static final HeaderKey<Integer> keepOnlineTimeoutSeconds = HeaderKey.of("keepOnlineTimeoutSeconds", 600, Integer.class);
    public static final HeaderKey<Boolean> keepOnlineIgnoreParent = HeaderKey.of("keepOnlineIgnoreParent", Boolean.getBoolean("device.session.keep-online.ignore-parent"), Boolean.class);
    public static final HeaderKey<Boolean> async = HeaderKey.of("async", false, Boolean.class);
    public static final HeaderKey<String> clientAddress = HeaderKey.of("cliAddr", "/", String.class);
    public static final HeaderKey<Boolean> sendAndForget = HeaderKey.of("sendAndForget", false);
    public static final HeaderKey<Long> timeout = HeaderKey.of("timeout", TimeUnit.SECONDS.toMillis(10L), Long.class);
    public static final HeaderKey<Boolean> mergeLatest = HeaderKey.of("mergeLatest", false, Boolean.class);
    public static final HeaderKey<Boolean> dispatchToParent = HeaderKey.of("dispatchToParent", false, Boolean.class);
    public static final HeaderKey<String> fragmentBodyMessageId = HeaderKey.of("frag_msg_id", null, String.class);
    public static final HeaderKey<Integer> fragmentNumber = HeaderKey.of("frag_num", 0, Integer.class);
    public static final HeaderKey<Boolean> fragmentLast = HeaderKey.of("frag_last", false, Boolean.class);
    public static final HeaderKey<Integer> fragmentPart = HeaderKey.of("frag_part", 0, Integer.class);
    public static final HeaderKey<String> sendFrom = HeaderKey.of("send-from", null, String.class);
    public static final HeaderKey<String> replyFrom = HeaderKey.of("reply-from", null, String.class);
    public static final HeaderKey<Boolean> useTimestampAsId = HeaderKey.of("useTimestampId", false, Boolean.class);
    public static final HeaderKey<String> dataId = HeaderKey.of("dataId", null, String.class);
    public static final HeaderKey<Boolean> partialProperties = HeaderKey.of("partialProperties", false, Boolean.class);
    @Deprecated
    public static final HeaderKey<Boolean> enableTrace = HeaderKey.of("_trace", Boolean.getBoolean("device.message.trace.enabled"), Boolean.class);
    public static final HeaderKey<Boolean> ignoreStorage = HeaderKey.of("ignoreStorage", false, Boolean.class);
    public static final HeaderKey<Boolean> ignoreLog = HeaderKey.of("ignoreLog", false, Boolean.class);
    public static final HeaderKey<Boolean> ignore = HeaderKey.of("ignore", false, Boolean.class);
    public static final HeaderKey<Boolean> ignoreSession = HeaderKey.of("ignoreSession", false, Boolean.class);
    public static final HeaderKey<Boolean> ignoreIfOffline = HeaderKey.of("ignoreIfOffline", false, Boolean.class);
    public static final HeaderKey<String> productId = HeaderKey.of("productId", null, String.class);
    public static final HeaderKey<Boolean> propertyContainsGeo = HeaderKey.of("containsGeo", true);
    public static final HeaderKey<String> geoProperty = HeaderKey.of("geoProperty", null, String.class);
    public static final HeaderKey<Boolean> clearAllSession = HeaderKey.of("clearAllSession", false, Boolean.class);
    public static final HeaderKey<Boolean> multiGateway = HeaderKey.of("multiGateway", false, Boolean.class);
    public static final HeaderKey<Object> routeKey = HeaderKey.of("_routeKey", null, Object.class);
    public static final HeaderKey<Boolean> replyNoMessageId = HeaderKey.of("replyNoMessageId", false, Boolean.class);

    public static void copyFunctionalHeader(Message from, Message to) {
        from.getHeader(async).ifPresent(val -> to.addHeader(async, val));
        from.getHeader(timeout).ifPresent(val -> to.addHeader(timeout, val));
        from.getHeader(sendAndForget).ifPresent(val -> to.addHeader(sendAndForget, val));
        from.getHeader(force).ifPresent(val -> to.addHeader(force, val));
        from.getHeader(ignore).ifPresent(val -> to.addHeader(ignore, val));
        from.getHeader(ignoreLog).ifPresent(val -> to.addHeader(ignoreLog, val));
    }
}

