/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.utils.SerializeUtils;

public class DerivedMetadataMessage
extends CommonDeviceMessage<DerivedMetadataMessage> {
    private String metadata;
    private boolean all;

    @Override
    public MessageType getMessageType() {
        return MessageType.DERIVED_METADATA;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializeUtils.writeNullableUTF(this.metadata, out);
        out.writeBoolean(this.all);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.metadata = SerializeUtils.readNullableUTF(in);
        this.all = in.readBoolean();
    }

    public String getMetadata() {
        return this.metadata;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setAll(boolean all) {
        this.all = all;
    }
}

