/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import javax.annotation.Nonnull;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.GenericHeaderSupport;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.ThingMessage;

public abstract class CommonThingMessage<SELF extends CommonThingMessage<SELF>>
extends GenericHeaderSupport<SELF>
implements ThingMessage {
    private static final long serialVersionUID = -6849794470754667710L;
    private String code;
    private String messageId;
    @Nonnull
    private String thingType;
    @Nonnull
    private String thingId;
    private long timestamp = System.currentTimeMillis();

    @Override
    public abstract MessageType getMessageType();

    public SELF thingId(String thingType, String thingId) {
        this.setThingType(thingType);
        this.setThingId(thingId);
        return (SELF)((CommonThingMessage)this.castSelf());
    }

    public SELF timestamp(long timestamp) {
        this.timestamp = timestamp;
        return (SELF)((CommonThingMessage)this.castSelf());
    }

    public SELF messageId(String messageId) {
        this.setMessageId(messageId);
        return (SELF)((CommonThingMessage)this.castSelf());
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = (JSONObject)FastBeanCopier.copy((Object)this, (Object)new JSONObject(), (String[])new String[0]);
        json.put("messageType", (Object)this.getMessageType().name());
        return json;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        JSONObject headers;
        FastBeanCopier.copy((Object)jsonObject, (Object)this, (String[])new String[]{"headers"});
        if (this.timestamp == 0L) {
            this.timestamp = System.currentTimeMillis();
        }
        if (null != (headers = jsonObject.getJSONObject("headers"))) {
            headers.forEach(this::addHeader);
        }
    }

    public String toString() {
        return this.toJson().toJSONString();
    }

    public SELF copy() {
        return (SELF)((CommonThingMessage)ThingMessage.super.copy());
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    @Nonnull
    public String getThingType() {
        return this.thingType;
    }

    @Override
    @Nonnull
    public String getThingId() {
        return this.thingId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setThingType(@Nonnull String thingType) {
        if (thingType == null) {
            throw new NullPointerException("thingType is marked non-null but is null");
        }
        this.thingType = thingType;
    }

    public void setThingId(@Nonnull String thingId) {
        if (thingId == null) {
            throw new NullPointerException("thingId is marked non-null but is null");
        }
        this.thingId = thingId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

