/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.Nonnull;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.GenericHeaderSupport;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.Message;

public class CommonDeviceMessageReply<Self extends CommonDeviceMessageReply<Self>>
extends GenericHeaderSupport<Self>
implements DeviceMessageReply {
    private static final long serialVersionUID = -6849794470754667710L;
    private boolean success = true;
    private String code;
    private String message;
    private String messageId;
    private String deviceId;
    private long timestamp = System.currentTimeMillis();

    @Override
    @JsonIgnore
    @JSONField(serialize=false)
    public final String getThingId() {
        return this.getDeviceId();
    }

    @Override
    public final String getThingType() {
        return DeviceMessageReply.super.getThingType();
    }

    public Self code(@Nonnull String code) {
        this.code = code;
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self message(@Nonnull String message) {
        this.message = message;
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self deviceId(@Nonnull String deviceId) {
        this.deviceId = deviceId;
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self success() {
        this.success = true;
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self success(boolean success) {
        this.success = success;
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self error(Throwable e) {
        DeviceMessageReply.super.error(e);
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self error(ErrorCode errorCode) {
        return (Self)this.error(errorCode.name(), errorCode.getText());
    }

    public Self error(String errorCode, String msg) {
        this.success = false;
        this.code = errorCode;
        this.message = msg;
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self from(@Nonnull Message message) {
        this.messageId = message.getMessageId();
        if (message instanceof DeviceMessage) {
            this.deviceId = ((DeviceMessage)message).getDeviceId();
        }
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self messageId(@Nonnull String messageId) {
        this.messageId = messageId;
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    public Self timestamp(long timestamp) {
        this.timestamp = timestamp;
        return (Self)((CommonDeviceMessageReply)this.castSelf());
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = (JSONObject)FastBeanCopier.copy((Object)this, JSONObject::new, (String[])new String[0]);
        json.put("messageType", (Object)this.getMessageType().name());
        return json;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        JSONObject headers;
        FastBeanCopier.copy((Object)jsonObject, (Object)this, (String[])new String[]{"headers"});
        if (this.timestamp == 0L) {
            this.timestamp = System.currentTimeMillis();
        }
        if (null != (headers = jsonObject.getJSONObject("headers"))) {
            headers.forEach(this::addHeader);
        }
    }

    public String toString() {
        return this.toJson().toJSONString();
    }

    public Self copy() {
        return (Self)((CommonDeviceMessageReply)DeviceMessageReply.super.copy());
    }

    public static <Self extends CommonDeviceMessageReply<Self>> CommonDeviceMessageReplyBuilder<Self> builder() {
        return new CommonDeviceMessageReplyBuilder();
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public CommonDeviceMessageReply(boolean success, String code, String message, String messageId, String deviceId, long timestamp) {
        this.success = success;
        this.code = code;
        this.message = message;
        this.messageId = messageId;
        this.deviceId = deviceId;
        this.timestamp = timestamp;
    }

    public CommonDeviceMessageReply() {
    }

    public static class CommonDeviceMessageReplyBuilder<Self extends CommonDeviceMessageReply<Self>> {
        private boolean success;
        private String code;
        private String message;
        private String messageId;
        private String deviceId;
        private long timestamp;

        CommonDeviceMessageReplyBuilder() {
        }

        public CommonDeviceMessageReplyBuilder<Self> success(boolean success) {
            this.success = success;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<Self> code(String code) {
            this.code = code;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<Self> message(String message) {
            this.message = message;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<Self> messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<Self> deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public CommonDeviceMessageReplyBuilder<Self> timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CommonDeviceMessageReply<Self> build() {
            return new CommonDeviceMessageReply(this.success, this.code, this.message, this.messageId, this.deviceId, this.timestamp);
        }

        public String toString() {
            return "CommonDeviceMessageReply.CommonDeviceMessageReplyBuilder(success=" + this.success + ", code=" + this.code + ", message=" + this.message + ", messageId=" + this.messageId + ", deviceId=" + this.deviceId + ", timestamp=" + this.timestamp + ")";
        }
    }
}

