/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.utils.SerializeUtils;

public class ChildDeviceMessageReply
extends CommonDeviceMessageReply<ChildDeviceMessageReply> {
    private String childDeviceId;
    private Message childDeviceMessage;

    @Override
    public MessageType getMessageType() {
        return MessageType.CHILD_REPLY;
    }

    @Override
    public ChildDeviceMessageReply error(Throwable e) {
        this.doWithChildReply(e, DeviceMessageReply::error);
        return (ChildDeviceMessageReply)super.error(e);
    }

    @Override
    public ChildDeviceMessageReply error(ErrorCode errorCode) {
        this.doWithChildReply(errorCode, DeviceMessageReply::error);
        return (ChildDeviceMessageReply)super.error(errorCode);
    }

    @Override
    public ChildDeviceMessageReply message(@Nonnull String message) {
        this.doWithChildReply(message, DeviceMessageReply::message);
        return (ChildDeviceMessageReply)super.message(message);
    }

    @Override
    public ChildDeviceMessageReply code(@Nonnull String code) {
        this.doWithChildReply(code, DeviceMessageReply::code);
        return (ChildDeviceMessageReply)super.code(code);
    }

    public <T> void doWithChildReply(T arg, BiConsumer<DeviceMessageReply, T> childReplyConsumer) {
        if (this.childDeviceMessage instanceof DeviceMessageReply) {
            DeviceMessageReply child = (DeviceMessageReply)this.childDeviceMessage;
            childReplyConsumer.accept(child, (DeviceMessageReply)arg);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        if (null != this.childDeviceMessage) {
            json.put("childDeviceMessage", (Object)this.childDeviceMessage.toJson());
        }
        return json;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(new JSONObject(Maps.filterKeys((Map)jsonObject, k -> !"childDeviceMessage".equals(k))));
        JSONObject json = jsonObject.getJSONObject("childDeviceMessage");
        if (json != null) {
            this.childDeviceMessage = MessageType.convertMessage((Map<String, Object>)json).orElse(null);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializeUtils.writeNullableUTF(this.childDeviceId, out);
        out.writeObject(this.childDeviceMessage);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.childDeviceId = SerializeUtils.readNullableUTF(in);
        this.childDeviceMessage = (Message)in.readObject();
    }

    public String getChildDeviceId() {
        return this.childDeviceId;
    }

    public Message getChildDeviceMessage() {
        return this.childDeviceMessage;
    }

    public void setChildDeviceId(String childDeviceId) {
        this.childDeviceId = childDeviceId;
    }

    public void setChildDeviceMessage(Message childDeviceMessage) {
        this.childDeviceMessage = childDeviceMessage;
    }
}

