/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Map;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.ChildDeviceMessageReply;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.utils.SerializeUtils;

public class ChildDeviceMessage
extends CommonDeviceMessage<ChildDeviceMessage>
implements RepayableDeviceMessage<ChildDeviceMessageReply> {
    private String childDeviceId;
    private Message childDeviceMessage;

    public static ChildDeviceMessage create(String deviceId, DeviceMessage message) {
        ChildDeviceMessage msg = new ChildDeviceMessage();
        msg.setDeviceId(deviceId);
        msg.setMessageId(message.getMessageId());
        msg.setChildDeviceId(message.getDeviceId());
        msg.setChildDeviceMessage(message);
        return msg;
    }

    @Override
    public ChildDeviceMessageReply newReply() {
        ChildDeviceMessageReply reply = new ChildDeviceMessageReply();
        if (this.childDeviceMessage instanceof RepayableDeviceMessage) {
            reply.setChildDeviceMessage(((RepayableDeviceMessage)this.childDeviceMessage).newReply());
        }
        reply.messageId(this.getMessageId());
        reply.deviceId(this.getDeviceId());
        reply.setChildDeviceId(this.getChildDeviceId());
        return reply;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        if (null != this.childDeviceMessage) {
            json.put("childDeviceMessage", (Object)this.childDeviceMessage.toJson());
        }
        return json;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(new JSONObject(Maps.filterKeys((Map)jsonObject, k -> !"childDeviceMessage".equals(k))));
        JSONObject json = jsonObject.getJSONObject("childDeviceMessage");
        if (json != null) {
            this.childDeviceMessage = MessageType.convertMessage((Map<String, Object>)json).orElse(null);
        }
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.CHILD;
    }

    @Override
    public void validate() {
        if (this.childDeviceMessage instanceof ChildDeviceMessage) {
            HashSet<String> deviceId = new HashSet<String>();
            Message msg = this.childDeviceMessage;
            do {
                String childId = ((ChildDeviceMessage)msg).getChildDeviceId();
                msg = ((ChildDeviceMessage)msg).getChildDeviceMessage();
                if (deviceId.contains(childId)) {
                    throw new DeviceOperationException(ErrorCode.CYCLIC_DEPENDENCE);
                }
                deviceId.add(childId);
            } while (msg instanceof ChildDeviceMessage);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializeUtils.writeNullableUTF(this.childDeviceId, out);
        out.writeObject(this.childDeviceMessage);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.childDeviceId = SerializeUtils.readNullableUTF(in);
        this.childDeviceMessage = (Message)in.readObject();
    }

    @Override
    public MessageType getReplyType() {
        return MessageType.CHILD_REPLY;
    }

    public String getChildDeviceId() {
        return this.childDeviceId;
    }

    public Message getChildDeviceMessage() {
        return this.childDeviceMessage;
    }

    public void setChildDeviceId(String childDeviceId) {
        this.childDeviceId = childDeviceId;
    }

    public void setChildDeviceMessage(Message childDeviceMessage) {
        this.childDeviceMessage = childDeviceMessage;
    }
}

