/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.jetlinks.core.message.CommonThingMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;

public class BatchMessage
extends CommonThingMessage<BatchMessage> {
    private List<Message> messages;

    @Override
    public MessageType getMessageType() {
        return MessageType.BATCH;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.messages == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.messages.size());
            for (Message message : this.messages) {
                MessageType.writeExternal(message, out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.messages.add(MessageType.readExternal(in));
            }
        }
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    private BatchMessage(List<Message> messages) {
        this.messages = messages;
    }

    public static BatchMessage of(List<Message> messages) {
        return new BatchMessage(messages);
    }

    public BatchMessage() {
    }
}

