/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.lang;

import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SeparatedString;
import org.jetlinks.core.utils.RecyclerUtils;
import org.jetlinks.core.utils.TopicUtils;

public class SharedPathString
extends SeparatedString {
    private static final SharedPathString EMPTY = new SharedPathString(new String[0]);

    @Override
    public final char separator() {
        return '/';
    }

    SharedPathString(String[] topic) {
        super(topic);
    }

    SharedPathString(String topic) {
        this(TopicUtils.split(topic, true, true));
    }

    @Override
    public SharedPathString intern() {
        return RecyclerUtils.intern(this);
    }

    public static SharedPathString empty() {
        return EMPTY;
    }

    public static SharedPathString of(String path, boolean intern) {
        return intern ? new SharedPathString(path).intern() : SharedPathString.of(TopicUtils.split(path));
    }

    public static SharedPathString of(CharSequence path) {
        if (path instanceof SharedPathString) {
            return (SharedPathString)path;
        }
        if (path instanceof SeparatedString) {
            return SharedPathString.of(((SeparatedString)path).unsafeSeparated());
        }
        if (path instanceof SeparatedCharSequence) {
            return SharedPathString.of(((SeparatedCharSequence)path).asStringArray());
        }
        return SharedPathString.of(String.valueOf(path));
    }

    @Override
    public SharedPathString internInner() {
        super.internInner();
        return this;
    }

    public static SharedPathString of(String path) {
        return SharedPathString.of(TopicUtils.split(path, true, true)).intern();
    }

    public static SharedPathString of(String[] path) {
        return new SharedPathString(path);
    }
}

