/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.lang;

import org.jetlinks.core.lang.AbstractSeparatedCharSequence;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SeparatedString2;
import org.jetlinks.core.lang.SeparatedString3;
import org.jetlinks.core.lang.SeparatedStringN;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.utils.RecyclerUtils;
import org.jetlinks.core.utils.TopicUtils;

public abstract class SeparatedString
extends AbstractSeparatedCharSequence {
    protected final String[] separated;

    SeparatedString(String[] separated) {
        this.separated = separated;
    }

    public static SeparatedCharSequence create(char separator, String ... arr) {
        if (separator == '/') {
            return SharedPathString.of(arr);
        }
        if (arr.length == 2) {
            return new SeparatedString2(separator, arr[0], arr[1]);
        }
        if (arr.length == 3) {
            return new SeparatedString3(separator, arr[0], arr[1], arr[2]);
        }
        return new SeparatedStringN(separator, arr);
    }

    public static CharSequence of(char separator, String[] arr) {
        if (arr.length == 1) {
            return arr[0];
        }
        return SeparatedString.create(separator, arr);
    }

    public static CharSequence of(char separator, String string, boolean intern) {
        if (string.isEmpty()) {
            return string;
        }
        String[] arr = intern ? TopicUtils.split(string, separator, (i, s) -> RecyclerUtils.intern(s)) : TopicUtils.split(string, separator);
        if (arr.length == 1) {
            return arr[0];
        }
        if (separator == '/') {
            return intern ? SharedPathString.of(arr).intern() : SharedPathString.of(arr);
        }
        if (arr.length == 2) {
            return intern ? new SeparatedString2(separator, arr[0], arr[1]).intern() : new SeparatedString2(separator, arr[0], arr[1]);
        }
        if (arr.length == 3) {
            return intern ? new SeparatedString3(separator, arr[0], arr[1], arr[2]).intern() : new SeparatedString3(separator, arr[0], arr[1], arr[2]);
        }
        SeparatedStringN n = new SeparatedStringN(separator, arr);
        return intern ? n.intern() : n;
    }

    public static CharSequence of(char separator, String string) {
        return SeparatedString.of(separator, string, true);
    }

    @Override
    public abstract char separator();

    @Override
    public int size() {
        return this.separated.length;
    }

    @Override
    public String get(int index) {
        return this.separated[index];
    }

    public String[] separated() {
        return (String[])this.separated.clone();
    }

    public String[] unsafeSeparated() {
        return this.separated;
    }

    @Override
    public SeparatedString internInner() {
        for (int i = 0; i < this.separated.length; ++i) {
            this.separated[i] = RecyclerUtils.intern(this.separated[i]);
        }
        return this;
    }

    @Override
    public SeparatedString intern() {
        return RecyclerUtils.intern(this);
    }
}

