/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.event;

import com.google.common.collect.Collections2;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hswebframework.web.dict.Dict;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.event.TopicPayload;
import org.jetlinks.core.utils.TopicUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class Subscription
implements Externalizable {
    private static final Logger log = LoggerFactory.getLogger(Subscription.class);
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Feature[] DEFAULT_FEATURES = new Feature[]{Feature.local, Feature.broker, Feature.shared};
    private String subscriber;
    private String[] topics;
    private Feature[] features;
    private transient Runnable doOnSubscribe;
    private transient Consumer<TopicPayload> onDropped;
    private int priority = Integer.MAX_VALUE;
    private long time;

    public Subscription() {
    }

    public Subscription(String subscriber, String[] topics, Feature[] features, Runnable doOnSubscribe, int priority) {
        this.subscriber = subscriber;
        this.topics = topics;
        this.features = features;
        this.doOnSubscribe = doOnSubscribe;
        this.priority = priority;
    }

    public void discard(TopicPayload payload) {
        if (this.onDropped != null) {
            this.onDropped.accept(payload);
        }
    }

    public void dropped(TopicPayload payload) {
        if (this.onDropped != null) {
            this.onDropped.accept(payload);
        } else {
            log.warn("eventbus buffer overflow, drop event:{},subscription:{}", (Object)payload.getTopic(), (Object)this);
        }
    }

    public Consumer<TopicPayload> getDropListener() {
        return this.onDropped;
    }

    public static Subscription of(String subscriber, String ... topic) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).build();
    }

    public static Subscription of(String subscriber, String[] topic, Feature ... features) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).features(features).build();
    }

    public static Subscription of(String subscriber, String topic, Feature ... features) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).features(features).build();
    }

    public Subscription copy(Feature ... newFeatures) {
        return new Subscription(this.subscriber, this.topics, newFeatures, null, null, this.priority, this.time);
    }

    public Subscription onSubscribe(Runnable sub) {
        this.doOnSubscribe = sub;
        return this;
    }

    public boolean hasFeature(Feature feature) {
        return feature.in(this.features);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.subscriber);
        out.writeInt(this.topics.length);
        for (String topic : this.topics) {
            out.writeUTF(topic);
        }
        out.writeLong(EnumDict.toMask((EnumDict[])this.features));
        out.writeInt(this.priority);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.subscriber = in.readUTF();
        int len = in.readInt();
        this.topics = new String[len];
        for (int i = 0; i < len; ++i) {
            this.topics[i] = in.readUTF();
        }
        this.features = EnumDict.getByMask(Feature.class, (long)in.readLong()).toArray(new Feature[0]);
        this.priority = in.readInt();
    }

    public String toString() {
        return "Subscription{subscriber='" + this.subscriber + '\'' + ", topics=" + Arrays.toString(this.topics) + ", features=" + Arrays.toString((Object[])this.features) + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public Subscription(String subscriber, String[] topics, Feature[] features, Runnable doOnSubscribe, Consumer<TopicPayload> onDropped, int priority, long time) {
        this.subscriber = subscriber;
        this.topics = topics;
        this.features = features;
        this.doOnSubscribe = doOnSubscribe;
        this.onDropped = onDropped;
        this.priority = priority;
        this.time = time;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public Feature[] getFeatures() {
        return this.features;
    }

    public Runnable getDoOnSubscribe() {
        return this.doOnSubscribe;
    }

    public Consumer<TopicPayload> getOnDropped() {
        return this.onDropped;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTime() {
        return this.time;
    }

    public static class Builder {
        private String subscriber;
        private final Set<String> topics = new HashSet<String>();
        private final Set<Feature> features = new HashSet<Feature>();
        private Runnable doOnSubscribe;
        private Consumer<TopicPayload> onDropped;
        private int priority;
        private long time;

        public Builder randomSubscriberId() {
            return this.subscriberId(UUID.randomUUID().toString());
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder subscriberId(String id) {
            this.subscriber = id;
            return this;
        }

        public Builder subscriberId(CharSequence id) {
            this.subscriber = String.valueOf(id);
            return this;
        }

        public Builder topics(CharSequence ... topics) {
            if (topics.length == 1) {
                this.topics.addAll(TopicUtils.expand(topics[0].toString()));
                return this;
            }
            return this.topics(Collections2.transform(Arrays.asList(topics), String::valueOf));
        }

        public Builder topics(String ... topics) {
            if (topics.length == 1) {
                this.topics.addAll(TopicUtils.expand(topics[0]));
                return this;
            }
            return this.topics(Arrays.asList(topics));
        }

        public Builder topics(Collection<String> topics) {
            this.topics.addAll(topics.stream().flatMap(topic -> TopicUtils.expand(topic).stream()).collect(Collectors.toSet()));
            return this;
        }

        public Builder features(Feature ... features) {
            this.features.addAll(Arrays.asList(features));
            return this;
        }

        public Builder doOnSubscribe(Runnable runnable) {
            this.doOnSubscribe = runnable;
            return this;
        }

        public Builder justLocal() {
            this.features.clear();
            return this.features(Feature.local);
        }

        public Builder justBroker() {
            this.features.clear();
            return this.features(Feature.broker);
        }

        public Builder onDropped(Consumer<TopicPayload> consumer) {
            this.onDropped = this.onDropped == null || this.onDropped == consumer ? consumer : this.onDropped.andThen(consumer);
            return this;
        }

        public Builder local() {
            return this.features(Feature.local);
        }

        public Builder broker() {
            return this.features(Feature.broker);
        }

        public Builder shared() {
            return this.features(Feature.shared);
        }

        public Builder sharedOldest() {
            return this.features(Feature.shared, Feature.sharedOldest);
        }

        public Builder sharedLocalFirst() {
            return this.features(Feature.shared, Feature.sharedLocalFirst);
        }

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Subscription build() {
            if (this.features.isEmpty()) {
                this.local();
            }
            Assert.notEmpty(this.topics, (String)"topic cannot be empty");
            Assert.hasText((String)this.subscriber, (String)"subscriber cannot be empty");
            return new Subscription(this.subscriber, this.topics.toArray(new String[0]), this.features.toArray(new Feature[0]), this.doOnSubscribe, this.onDropped, this.priority, this.time);
        }
    }

    @Dict(value="subscription-feature")
    public static enum Feature implements EnumDict<String>
    {
        shared("shared"),
        local("\u8ba2\u9605\u672c\u5730\u6d88\u606f"),
        broker("\u8ba2\u9605\u96c6\u7fa4\u6d88\u606f"),
        sharedOldest("\u76f8\u540c\u8ba2\u9605\u8005\u603b\u662f\u6700\u5148\u8ba2\u9605\u7684\u6536\u5230\u6570\u636e"),
        sharedLocalFirst("\u96c6\u7fa4\u4e0b\u76f8\u540c\u7684\u8ba2\u9605\u8005\u603b\u662f\u672c\u5730\u7684\u4f18\u5148\u6536\u5230\u6570\u636e"),
        safetySerialization("\u5b89\u5168\u5e8f\u5217\u5316"),
        sharedHashed("\u4f7f\u7528hash\u65b9\u5f0f\u8def\u7531\u5171\u4eab\u8ba2\u9605"),
        sharedMinimumLoad("\u4f7f\u7528\u6700\u5c0f\u8d1f\u8f7d\u65b9\u5f0f\u8def\u7531\u5171\u4eab\u8ba2\u9605");

        private final String text;
        public static final Feature[] clusterFeatures;
        public static final Feature[] clusterSharedFeatures;
        public static final Feature[] clusterSharedLocalFirstFeatures;
        public static final Feature[] clusterSharedHashFeatures;
        public static final Feature[] clusterSharedMinimumLoadFeatures;
        public static final Feature[] clusterSharedOldestFeatures;

        public String getValue() {
            return this.name();
        }

        private Feature(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        static {
            clusterFeatures = new Feature[]{local, broker};
            clusterSharedFeatures = new Feature[]{local, broker, shared};
            clusterSharedLocalFirstFeatures = new Feature[]{local, broker, shared, sharedLocalFirst};
            clusterSharedHashFeatures = new Feature[]{local, broker, shared, sharedHashed};
            clusterSharedMinimumLoadFeatures = new Feature[]{local, broker, shared, sharedMinimumLoad};
            clusterSharedOldestFeatures = new Feature[]{local, broker, shared, sharedOldest};
        }
    }
}

