/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.enums;

import java.net.SocketTimeoutException;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import javax.validation.ValidationException;
import org.jetlinks.core.exception.DeviceOperationException;

public enum ErrorCode {
    REQUEST_HANDLING("error.code.request_handling"),
    CLIENT_OFFLINE("error.code.client_offline"),
    CONNECTION_LOST("error.code.connection_lost"),
    NO_REPLY("error.code.no_reply"),
    TIME_OUT("error.code.time_out"),
    SYSTEM_ERROR("error.code.system_error"),
    UNSUPPORTED_MESSAGE("error.code.unsupported_message"),
    PARAMETER_ERROR("error.code.parameter_error"),
    PARAMETER_UNDEFINED("error.code.parameter_undefined"),
    FUNCTION_UNDEFINED("error.code.function_undefined"),
    PROPERTY_UNDEFINED("error.code.property_undefined"),
    UNKNOWN_PARENT_DEVICE("error.code.unknown_parent_device"),
    CYCLIC_DEPENDENCE("error.code.cyclic_dependence"),
    SERVER_NOT_AVAILABLE("error.code.server_not_available"),
    UNKNOWN("error.code.unknown"),
    SYSTEM_BUSY("error.code.system_busy");

    private final String text;

    public static Optional<ErrorCode> of(String code) {
        if (code == null) {
            return Optional.empty();
        }
        for (ErrorCode value : ErrorCode.values()) {
            if (!value.name().equalsIgnoreCase(code)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static ErrorCode of(Throwable e) {
        if (e instanceof DeviceOperationException) {
            return ((DeviceOperationException)e).getCode();
        }
        if (e instanceof IllegalArgumentException || e instanceof org.hswebframework.web.exception.ValidationException || e instanceof ValidationException || e instanceof NullPointerException || e instanceof IndexOutOfBoundsException) {
            return PARAMETER_ERROR;
        }
        if (e instanceof UnsupportedOperationException) {
            return UNSUPPORTED_MESSAGE;
        }
        if (e instanceof TimeoutException || e instanceof SocketTimeoutException || e instanceof io.netty.handler.timeout.TimeoutException) {
            return TIME_OUT;
        }
        return SYSTEM_ERROR;
    }

    public String getText() {
        return this.text;
    }

    private ErrorCode(String text) {
        this.text = text;
    }
}

