/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.device.manager;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.utils.SerializeUtils;

public class BindInfo
implements Externalizable {
    private String key;
    private String deviceId;
    private String description;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.key);
        out.writeUTF(this.deviceId);
        SerializeUtils.writeNullableUTF(this.description, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = in.readUTF();
        this.deviceId = in.readUTF();
        this.description = SerializeUtils.readNullableUTF(in);
    }

    public String getKey() {
        return this.key;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private BindInfo(String key, String deviceId, String description) {
        this.key = key;
        this.deviceId = deviceId;
        this.description = description;
    }

    public static BindInfo of(String key, String deviceId, String description) {
        return new BindInfo(key, deviceId, description);
    }

    public BindInfo() {
    }
}

