/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.device;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigKeyValue;

public class DeviceInfo
implements Serializable {
    private static final long serialVersionUID = -6849794470754667710L;
    private String id;
    private String productId;
    private String productVersion;
    private String protocol;
    private String metadata;
    private Map<String, Object> configuration = new HashMap<String, Object>();

    public DeviceInfo addConfig(String key, Object value) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, Object>();
        }
        this.configuration.put(key, value);
        return this;
    }

    public DeviceInfo addConfigIfAbsent(String key, Object value) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, Object>();
        }
        this.configuration.putIfAbsent(key, value);
        return this;
    }

    public DeviceInfo addConfigs(Map<String, ?> configs) {
        if (configs == null) {
            return this;
        }
        configs.forEach(this::addConfig);
        return this;
    }

    public <T> DeviceInfo addConfig(ConfigKey<T> key, T value) {
        this.addConfig(key.getKey(), value);
        return this;
    }

    public <T> DeviceInfo addConfig(ConfigKeyValue<T> keyValue) {
        this.addConfig(keyValue.getKey(), keyValue.getValue());
        return this;
    }

    public static DeviceInfoBuilder builder() {
        return new DeviceInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public DeviceInfo(String id, String productId, String productVersion, String protocol, String metadata, Map<String, Object> configuration) {
        this.id = id;
        this.productId = productId;
        this.productVersion = productVersion;
        this.protocol = protocol;
        this.metadata = metadata;
        this.configuration = configuration;
    }

    public DeviceInfo() {
    }

    public static class DeviceInfoBuilder {
        private String id;
        private String productId;
        private String productVersion;
        private String protocol;
        private String metadata;
        private Map<String, Object> configuration;

        DeviceInfoBuilder() {
        }

        public DeviceInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DeviceInfoBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public DeviceInfoBuilder productVersion(String productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public DeviceInfoBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public DeviceInfoBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public DeviceInfoBuilder configuration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public DeviceInfo build() {
            return new DeviceInfo(this.id, this.productId, this.productVersion, this.protocol, this.metadata, this.configuration);
        }

        public String toString() {
            return "DeviceInfo.DeviceInfoBuilder(id=" + this.id + ", productId=" + this.productId + ", productVersion=" + this.productVersion + ", protocol=" + this.protocol + ", metadata=" + this.metadata + ", configuration=" + this.configuration + ")";
        }
    }
}

