/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.defaults.Authenticator;
import org.jetlinks.core.defaults.ExpandsConfigMetadataSupplier;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.CompositeDeviceMessageSenderInterceptor;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceStateChecker;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.core.metadata.DeviceMetadataCodecs;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.Feature;
import org.jetlinks.core.route.Route;
import org.jetlinks.core.server.ClientConnection;
import org.jetlinks.core.server.DeviceGatewayContext;
import org.jetlinks.core.things.ThingRpcSupportChain;
import org.reactivestreams.Publisher;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeProtocolSupport
implements ProtocolSupport {
    private String id;
    private String name;
    private String description;
    private DeviceMetadataCodec metadataCodec = DeviceMetadataCodecs.defaultCodec();
    private final Map<String, Supplier<Mono<ConfigMetadata>>> configMetadata = new ConcurrentHashMap<String, Supplier<Mono<ConfigMetadata>>>();
    private final Map<String, Supplier<Mono<DeviceMetadata>>> defaultDeviceMetadata = new ConcurrentHashMap<String, Supplier<Mono<DeviceMetadata>>>();
    private final Map<String, Supplier<Mono<DeviceMessageCodec>>> messageCodecSupports = new ConcurrentHashMap<String, Supplier<Mono<DeviceMessageCodec>>>();
    private Map<String, ExpandsConfigMetadataSupplier> expandsConfigSupplier = new ConcurrentHashMap<String, ExpandsConfigMetadataSupplier>();
    private DeviceMessageSenderInterceptor deviceMessageSenderInterceptor;
    private Map<String, Authenticator> authenticators = new ConcurrentHashMap<String, Authenticator>();
    private DeviceStateChecker deviceStateChecker;
    private volatile boolean disposed;
    private Disposable.Composite composite = Disposables.composite();
    private Mono<ConfigMetadata> initConfigMetadata = Mono.empty();
    private List<DeviceMetadataCodec> metadataCodecs = new ArrayList<DeviceMetadataCodec>();
    private List<Consumer<Map<String, Object>>> doOnInit = new CopyOnWriteArrayList<Consumer<Map<String, Object>>>();
    private Function<DeviceOperator, Mono<Void>> onDeviceRegister;
    private Function<DeviceOperator, Mono<Void>> onDeviceUnRegister;
    private Function<DeviceOperator, Mono<Void>> onDeviceMetadataChanged;
    private Function<DeviceProductOperator, Mono<Void>> onProductRegister;
    private Function<DeviceProductOperator, Mono<Void>> onProductUnRegister;
    private Function<DeviceProductOperator, Mono<Void>> onProductMetadataChanged;
    private BiFunction<DeviceOperator, Flux<DeviceOperator>, Mono<Void>> onChildBind;
    private BiFunction<DeviceOperator, Flux<DeviceOperator>, Mono<Void>> onChildUnbind;
    private Map<String, Function<DeviceInfo, Mono<DeviceInfo>>> onBeforeCreate = new ConcurrentHashMap<String, Function<DeviceInfo, Mono<DeviceInfo>>>();
    private Map<String, BiFunction<ClientConnection, DeviceGatewayContext, Mono<Void>>> connectionHandlers = new ConcurrentHashMap<String, BiFunction<ClientConnection, DeviceGatewayContext, Mono<Void>>>();
    private Map<String, Flux<Feature>> features = new ConcurrentHashMap<String, Flux<Feature>>();
    private List<Feature> globalFeatures = new CopyOnWriteArrayList<Feature>();
    private Map<String, List<Route>> routes = new ConcurrentHashMap<String, List<Route>>();
    private Map<String, Supplier<String>> docFiles = new ConcurrentHashMap<String, Supplier<String>>();
    private ThingRpcSupportChain rpcChain;
    private int order = Integer.MAX_VALUE;

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.composite.dispose();
        this.configMetadata.clear();
        this.defaultDeviceMetadata.clear();
        this.messageCodecSupports.clear();
        this.expandsConfigSupplier.clear();
    }

    public void setInitConfigMetadata(ConfigMetadata metadata) {
        this.initConfigMetadata = Mono.just((Object)metadata);
    }

    @Override
    public void init(Map<String, Object> configuration) {
        for (Consumer<Map<String, Object>> mapConsumer : this.doOnInit) {
            mapConsumer.accept(configuration);
        }
    }

    public CompositeProtocolSupport doOnDispose(Disposable disposable) {
        this.composite.add(disposable);
        return this;
    }

    public CompositeProtocolSupport doOnInit(Consumer<Map<String, Object>> runnable) {
        this.doOnInit.add(runnable);
        return this;
    }

    public void addMessageCodecSupport(Transport transport, Supplier<Mono<DeviceMessageCodec>> supplier) {
        this.messageCodecSupports.put(transport.getId(), supplier);
    }

    public void addMessageCodecSupport(Transport transport, DeviceMessageCodec codec) {
        this.messageCodecSupports.put(transport.getId(), () -> Mono.just((Object)codec));
    }

    public void addMessageCodecSupport(DeviceMessageCodec codec) {
        this.addMessageCodecSupport(codec.getSupportTransport(), codec);
    }

    public void removeMessageCodecSupport(Transport transport) {
        this.messageCodecSupports.remove(transport.getId());
    }

    public void addAuthenticator(Transport transport, Authenticator authenticator) {
        this.authenticators.put(transport.getId(), authenticator);
    }

    public void addDefaultMetadata(Transport transport, Mono<DeviceMetadata> metadata) {
        this.defaultDeviceMetadata.put(transport.getId(), () -> metadata);
    }

    public void addDefaultMetadata(Transport transport, DeviceMetadata metadata) {
        this.defaultDeviceMetadata.put(transport.getId(), () -> Mono.just((Object)metadata));
    }

    @Override
    public Mono<DeviceMessageSenderInterceptor> getSenderInterceptor() {
        return Mono.justOrEmpty((Object)this.deviceMessageSenderInterceptor).defaultIfEmpty((Object)DeviceMessageSenderInterceptor.DO_NOTING);
    }

    public synchronized void addMessageSenderInterceptor(DeviceMessageSenderInterceptor interceptor) {
        if (this.deviceMessageSenderInterceptor == null) {
            this.deviceMessageSenderInterceptor = interceptor;
        } else {
            CompositeDeviceMessageSenderInterceptor composite;
            if (!(this.deviceMessageSenderInterceptor instanceof CompositeDeviceMessageSenderInterceptor)) {
                composite = new CompositeDeviceMessageSenderInterceptor();
                composite.addInterceptor(this.deviceMessageSenderInterceptor);
            } else {
                composite = (CompositeDeviceMessageSenderInterceptor)this.deviceMessageSenderInterceptor;
            }
            composite.addInterceptor(interceptor);
            this.deviceMessageSenderInterceptor = composite;
        }
    }

    public void addConfigMetadata(Transport transport, Supplier<Mono<ConfigMetadata>> metadata) {
        this.configMetadata.put(transport.getId(), metadata);
    }

    public void addConfigMetadata(Transport transport, ConfigMetadata metadata) {
        this.configMetadata.put(transport.getId(), () -> Mono.just((Object)metadata));
    }

    public void setExpandsConfigMetadata(Transport transport, ExpandsConfigMetadataSupplier supplier) {
        this.expandsConfigSupplier.put(transport.getId(), supplier);
    }

    public void addRoutes(Transport transport, Collection<? extends Route> routes) {
        this.routes.computeIfAbsent(transport.getId(), id -> new ArrayList()).addAll(routes);
    }

    @Override
    public Flux<ConfigMetadata> getMetadataExpandsConfig(Transport transport, DeviceMetadataType metadataType, String metadataId, String dataTypeId) {
        return Optional.ofNullable(this.expandsConfigSupplier.get(transport.getId())).map(supplier -> supplier.getConfigMetadata(metadataType, metadataId, dataTypeId)).orElse(Flux.empty());
    }

    @Override
    public Mono<DeviceMetadata> getDefaultMetadata(Transport transport) {
        return Optional.ofNullable(this.defaultDeviceMetadata.get(transport.getId())).map(Supplier::get).orElse(Mono.empty());
    }

    public Flux<Transport> getSupportedTransport() {
        return Flux.fromIterable(this.messageCodecSupports.values()).flatMap(Supplier::get).map(DeviceMessageCodec::getSupportTransport).distinct(Transport::getId);
    }

    @Override
    @Nonnull
    public Mono<? extends DeviceMessageCodec> getMessageCodec(Transport transport) {
        return this.messageCodecSupports.getOrDefault(transport.getId(), Mono::empty).get();
    }

    @Override
    @Nonnull
    public DeviceMetadataCodec getMetadataCodec() {
        return this.metadataCodec;
    }

    @Override
    public Flux<DeviceMetadataCodec> getMetadataCodecs() {
        return Flux.merge((Publisher[])new Publisher[]{Flux.just((Object)this.metadataCodec), Flux.fromIterable(this.metadataCodecs)});
    }

    public void addDeviceMetadataCodec(DeviceMetadataCodec codec) {
        this.metadataCodecs.add(codec);
    }

    @Override
    @Nonnull
    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceOperator deviceOperation) {
        return Mono.justOrEmpty((Object)this.authenticators.get(request.getTransport().getId())).flatMap(at -> at.authenticate(request, deviceOperation).defaultIfEmpty((Object)AuthenticationResponse.error(400, "\u65e0\u6cd5\u83b7\u53d6\u8ba4\u8bc1\u7ed3\u679c"))).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u8bf7\u6c42:" + request)));
    }

    @Override
    @Nonnull
    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceRegistry registry) {
        return Mono.justOrEmpty((Object)this.authenticators.get(request.getTransport().getId())).flatMap(at -> at.authenticate(request, registry).defaultIfEmpty((Object)AuthenticationResponse.error(400, "\u65e0\u6cd5\u83b7\u53d6\u8ba4\u8bc1\u7ed3\u679c"))).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u8bf7\u6c42:" + request)));
    }

    @Override
    public Mono<ConfigMetadata> getConfigMetadata(Transport transport) {
        return this.configMetadata.getOrDefault(transport.getId(), Mono::empty).get();
    }

    @Override
    public Mono<ConfigMetadata> getInitConfigMetadata() {
        return this.initConfigMetadata;
    }

    @Override
    @Nonnull
    public Mono<DeviceStateChecker> getStateChecker() {
        return Mono.justOrEmpty((Object)this.deviceStateChecker);
    }

    public CompositeProtocolSupport doOnDeviceRegister(Function<DeviceOperator, Mono<Void>> executor) {
        this.onDeviceRegister = executor;
        return this;
    }

    public CompositeProtocolSupport doOnDeviceUnRegister(Function<DeviceOperator, Mono<Void>> executor) {
        this.onDeviceUnRegister = executor;
        return this;
    }

    public CompositeProtocolSupport doOnProductRegister(Function<DeviceProductOperator, Mono<Void>> executor) {
        this.onProductRegister = executor;
        return this;
    }

    public CompositeProtocolSupport doOnProductUnRegister(Function<DeviceProductOperator, Mono<Void>> executor) {
        this.onProductUnRegister = executor;
        return this;
    }

    public CompositeProtocolSupport doOnProductMetadataChanged(Function<DeviceProductOperator, Mono<Void>> executor) {
        this.onProductMetadataChanged = executor;
        return this;
    }

    public CompositeProtocolSupport doOnDeviceMetadataChanged(Function<DeviceOperator, Mono<Void>> executor) {
        this.onDeviceMetadataChanged = executor;
        return this;
    }

    public void doOnClientConnect(Transport transport, BiFunction<ClientConnection, DeviceGatewayContext, Mono<Void>> handler) {
        this.connectionHandlers.put(transport.getId(), handler);
    }

    @Override
    public Mono<Void> onDeviceRegister(DeviceOperator operator) {
        return this.onDeviceRegister != null ? this.onDeviceRegister.apply(operator) : Mono.empty();
    }

    @Override
    public Mono<Void> onDeviceUnRegister(DeviceOperator operator) {
        return this.onDeviceUnRegister != null ? this.onDeviceUnRegister.apply(operator) : Mono.empty();
    }

    @Override
    public Mono<Void> onProductRegister(DeviceProductOperator operator) {
        return this.onProductRegister != null ? this.onProductRegister.apply(operator) : Mono.empty();
    }

    @Override
    public Mono<Void> onProductUnRegister(DeviceProductOperator operator) {
        return this.onProductUnRegister != null ? this.onProductUnRegister.apply(operator) : Mono.empty();
    }

    @Override
    public Mono<Void> onDeviceMetadataChanged(DeviceOperator operator) {
        return this.onDeviceMetadataChanged != null ? this.onDeviceMetadataChanged.apply(operator) : Mono.empty();
    }

    @Override
    public Mono<Void> onProductMetadataChanged(DeviceProductOperator operator) {
        return this.onProductMetadataChanged != null ? this.onProductMetadataChanged.apply(operator) : Mono.empty();
    }

    public void doOnChildBind(BiFunction<DeviceOperator, Flux<DeviceOperator>, Mono<Void>> onChildBind) {
        this.onChildBind = onChildBind;
    }

    public void doOnChildUnbind(BiFunction<DeviceOperator, Flux<DeviceOperator>, Mono<Void>> onChildUnbind) {
        this.onChildUnbind = onChildUnbind;
    }

    @Override
    public Mono<Void> onClientConnect(Transport transport, ClientConnection connection, DeviceGatewayContext context) {
        BiFunction<ClientConnection, DeviceGatewayContext, Mono<Void>> function = this.connectionHandlers.get(transport.getId());
        if (function == null) {
            return Mono.empty();
        }
        return function.apply(connection, context);
    }

    @Override
    public Mono<Void> onChildBind(DeviceOperator gateway, Flux<DeviceOperator> child) {
        return this.onChildBind == null ? Mono.empty() : this.onChildBind.apply(gateway, child);
    }

    @Override
    public Mono<Void> onChildUnbind(DeviceOperator gateway, Flux<DeviceOperator> child) {
        return this.onChildUnbind == null ? Mono.empty() : this.onChildUnbind.apply(gateway, child);
    }

    public void addFeature(Transport transport, Feature ... features) {
        this.addFeature(transport, (Flux<Feature>)Flux.just((Object[])features));
    }

    public void addFeature(Transport transport, Iterable<Feature> features) {
        this.addFeature(transport, (Flux<Feature>)Flux.fromIterable(features));
    }

    public void addFeature(Transport transport, Flux<Feature> features) {
        this.features.put(transport.getId(), features);
    }

    public void addFeature(Feature ... features) {
        this.addFeature(Arrays.asList(features));
    }

    public void addFeature(Iterable<Feature> features) {
        features.forEach(this.globalFeatures::add);
    }

    public void onBeforeDeviceCreate(Transport transport, Function<DeviceInfo, Mono<DeviceInfo>> listener) {
        this.onBeforeCreate.put(transport.getId(), listener);
    }

    public void setDocument(Transport transport, String documentUrlOrFile, ClassLoader loader) {
        if (documentUrlOrFile.startsWith("http")) {
            this.setDocument(transport, () -> documentUrlOrFile);
        } else {
            this.setDocument(transport, () -> new ClassPathResource(documentUrlOrFile, loader));
        }
    }

    public void setDocument(Transport transport, Supplier<String> document) {
        this.docFiles.put(transport.getId(), document);
    }

    public void setDocument(Transport transport, Callable<Resource> document) {
        this.setDocument(transport, () -> {
            try {
                Resource resource = (Resource)document.call();
                if (!resource.exists()) return null;
                try (InputStream input = resource.getInputStream();){
                    String string = StreamUtils.copyToString((InputStream)input, (Charset)StandardCharsets.UTF_8);
                    return string;
                }
            }
            catch (Throwable throwable6) {
                // empty catch block
            }
            return null;
        });
    }

    @Override
    public Mono<DeviceInfo> doBeforeDeviceCreate(Transport transport, DeviceInfo deviceInfo) {
        Function<DeviceInfo, Mono<DeviceInfo>> listener = this.onBeforeCreate.get(transport.getId());
        if (null != listener) {
            return listener.apply(deviceInfo);
        }
        return ProtocolSupport.super.doBeforeDeviceCreate(transport, deviceInfo);
    }

    @Override
    public Flux<Feature> getFeatures(Transport transport) {
        return Flux.concat((Publisher[])new Publisher[]{Flux.fromIterable(this.globalFeatures), (Publisher)this.features.getOrDefault(transport.getId(), (Flux<Feature>)Flux.empty())}).distinct(Feature::getId);
    }

    @Override
    public Flux<Route> getRoutes(Transport transport) {
        return Flux.fromIterable((Iterable)this.routes.getOrDefault(transport.getId(), Collections.emptyList()));
    }

    @Override
    public String getDocument(Transport transport) {
        Supplier<String> docFile = this.docFiles.get(transport.getId());
        if (docFile == null) {
            return null;
        }
        return docFile.get();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public DeviceStateChecker getDeviceStateChecker() {
        return this.deviceStateChecker;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Disposable.Composite getComposite() {
        return this.composite;
    }

    public List<Consumer<Map<String, Object>>> getDoOnInit() {
        return this.doOnInit;
    }

    public Function<DeviceOperator, Mono<Void>> getOnDeviceRegister() {
        return this.onDeviceRegister;
    }

    public Function<DeviceOperator, Mono<Void>> getOnDeviceUnRegister() {
        return this.onDeviceUnRegister;
    }

    public Function<DeviceOperator, Mono<Void>> getOnDeviceMetadataChanged() {
        return this.onDeviceMetadataChanged;
    }

    public Function<DeviceProductOperator, Mono<Void>> getOnProductRegister() {
        return this.onProductRegister;
    }

    public Function<DeviceProductOperator, Mono<Void>> getOnProductUnRegister() {
        return this.onProductUnRegister;
    }

    public Function<DeviceProductOperator, Mono<Void>> getOnProductMetadataChanged() {
        return this.onProductMetadataChanged;
    }

    public BiFunction<DeviceOperator, Flux<DeviceOperator>, Mono<Void>> getOnChildBind() {
        return this.onChildBind;
    }

    public BiFunction<DeviceOperator, Flux<DeviceOperator>, Mono<Void>> getOnChildUnbind() {
        return this.onChildUnbind;
    }

    public Map<String, Function<DeviceInfo, Mono<DeviceInfo>>> getOnBeforeCreate() {
        return this.onBeforeCreate;
    }

    public Map<String, BiFunction<ClientConnection, DeviceGatewayContext, Mono<Void>>> getConnectionHandlers() {
        return this.connectionHandlers;
    }

    public Map<String, Flux<Feature>> getFeatures() {
        return this.features;
    }

    public List<Feature> getGlobalFeatures() {
        return this.globalFeatures;
    }

    public Map<String, List<Route>> getRoutes() {
        return this.routes;
    }

    public Map<String, Supplier<String>> getDocFiles() {
        return this.docFiles;
    }

    @Override
    public ThingRpcSupportChain getRpcChain() {
        return this.rpcChain;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMetadataCodec(DeviceMetadataCodec metadataCodec) {
        this.metadataCodec = metadataCodec;
    }

    public void setExpandsConfigSupplier(Map<String, ExpandsConfigMetadataSupplier> expandsConfigSupplier) {
        this.expandsConfigSupplier = expandsConfigSupplier;
    }

    public void setAuthenticators(Map<String, Authenticator> authenticators) {
        this.authenticators = authenticators;
    }

    public void setDeviceStateChecker(DeviceStateChecker deviceStateChecker) {
        this.deviceStateChecker = deviceStateChecker;
    }

    public void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public void setComposite(Disposable.Composite composite) {
        this.composite = composite;
    }

    public void setMetadataCodecs(List<DeviceMetadataCodec> metadataCodecs) {
        this.metadataCodecs = metadataCodecs;
    }

    public void setDoOnInit(List<Consumer<Map<String, Object>>> doOnInit) {
        this.doOnInit = doOnInit;
    }

    public void setOnDeviceRegister(Function<DeviceOperator, Mono<Void>> onDeviceRegister) {
        this.onDeviceRegister = onDeviceRegister;
    }

    public void setOnDeviceUnRegister(Function<DeviceOperator, Mono<Void>> onDeviceUnRegister) {
        this.onDeviceUnRegister = onDeviceUnRegister;
    }

    public void setOnDeviceMetadataChanged(Function<DeviceOperator, Mono<Void>> onDeviceMetadataChanged) {
        this.onDeviceMetadataChanged = onDeviceMetadataChanged;
    }

    public void setOnProductRegister(Function<DeviceProductOperator, Mono<Void>> onProductRegister) {
        this.onProductRegister = onProductRegister;
    }

    public void setOnProductUnRegister(Function<DeviceProductOperator, Mono<Void>> onProductUnRegister) {
        this.onProductUnRegister = onProductUnRegister;
    }

    public void setOnProductMetadataChanged(Function<DeviceProductOperator, Mono<Void>> onProductMetadataChanged) {
        this.onProductMetadataChanged = onProductMetadataChanged;
    }

    public void setOnChildBind(BiFunction<DeviceOperator, Flux<DeviceOperator>, Mono<Void>> onChildBind) {
        this.onChildBind = onChildBind;
    }

    public void setOnChildUnbind(BiFunction<DeviceOperator, Flux<DeviceOperator>, Mono<Void>> onChildUnbind) {
        this.onChildUnbind = onChildUnbind;
    }

    public void setOnBeforeCreate(Map<String, Function<DeviceInfo, Mono<DeviceInfo>>> onBeforeCreate) {
        this.onBeforeCreate = onBeforeCreate;
    }

    public void setConnectionHandlers(Map<String, BiFunction<ClientConnection, DeviceGatewayContext, Mono<Void>>> connectionHandlers) {
        this.connectionHandlers = connectionHandlers;
    }

    public void setFeatures(Map<String, Flux<Feature>> features) {
        this.features = features;
    }

    public void setGlobalFeatures(List<Feature> globalFeatures) {
        this.globalFeatures = globalFeatures;
    }

    public void setRoutes(Map<String, List<Route>> routes) {
        this.routes = routes;
    }

    public void setDocFiles(Map<String, Supplier<String>> docFiles) {
        this.docFiles = docFiles;
    }

    public void setRpcChain(ThingRpcSupportChain rpcChain) {
        this.rpcChain = rpcChain;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private Map<String, Supplier<Mono<ConfigMetadata>>> getConfigMetadata() {
        return this.configMetadata;
    }

    private Map<String, Supplier<Mono<DeviceMetadata>>> getDefaultDeviceMetadata() {
        return this.defaultDeviceMetadata;
    }

    private Map<String, Supplier<Mono<DeviceMessageCodec>>> getMessageCodecSupports() {
        return this.messageCodecSupports;
    }

    private Map<String, ExpandsConfigMetadataSupplier> getExpandsConfigSupplier() {
        return this.expandsConfigSupplier;
    }

    private DeviceMessageSenderInterceptor getDeviceMessageSenderInterceptor() {
        return this.deviceMessageSenderInterceptor;
    }

    private void setDeviceMessageSenderInterceptor(DeviceMessageSenderInterceptor deviceMessageSenderInterceptor) {
        this.deviceMessageSenderInterceptor = deviceMessageSenderInterceptor;
    }

    private Map<String, Authenticator> getAuthenticators() {
        return this.authenticators;
    }
}

