/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigKeyValue;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceMessageSender;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingRpcSupport;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class BlockingDeviceOperator
implements DeviceOperator {
    private final DeviceOperator target;
    private final Duration timeout;
    private final ContextView context;

    @Override
    public String getId() {
        return this.target.getId();
    }

    @Override
    public ThingType getType() {
        return this.target.getType();
    }

    @Override
    public String getDeviceId() {
        return this.target.getDeviceId();
    }

    private <T> T await(Mono<T> task) {
        return Reactors.await(task.contextWrite(this.context), this.timeout);
    }

    @Nullable
    public String getConnectionServerIdNow() {
        return this.await(this.getConnectionServerId());
    }

    @Override
    public Mono<String> getConnectionServerId() {
        return this.target.getConnectionServerId();
    }

    @Nullable
    public String getSessionIdNow() {
        return this.await(this.getConnectionServerId());
    }

    @Override
    public Mono<String> getSessionId() {
        return this.target.getSessionId();
    }

    @Nullable
    public String getAddressNow() {
        return this.await(this.getConnectionServerId());
    }

    @Override
    public Mono<String> getAddress() {
        return this.target.getAddress();
    }

    @Override
    public Mono<Void> setAddress(String address) {
        return this.target.setAddress(address);
    }

    @Override
    public Mono<Boolean> putState(byte state) {
        return this.target.putState(state);
    }

    public Byte getStateNow() {
        return this.await(this.getState());
    }

    @Override
    public Mono<Byte> getState() {
        return this.target.getState();
    }

    public Byte checkStateNow() {
        return this.await(this.checkState());
    }

    @Override
    public Mono<Byte> checkState() {
        return this.target.checkState();
    }

    public Long getOnlineTimeNow() {
        return this.await(this.target.getOnlineTime());
    }

    @Override
    public Mono<Long> getOnlineTime() {
        return this.target.getOnlineTime();
    }

    public Long getOfflineTimeNow() {
        return this.await(this.target.getOnlineTime());
    }

    @Override
    public Mono<Long> getOfflineTime() {
        return this.target.getOfflineTime();
    }

    @Override
    public Mono<Boolean> online(String serverId, String sessionId) {
        return this.target.online(serverId, sessionId);
    }

    @Override
    public Mono<Boolean> online(String serverId, String sessionId, String address) {
        return this.target.online(serverId, sessionId, address);
    }

    @Override
    public Mono<Boolean> online(String serverId, String address, long onlineTime) {
        return this.target.online(serverId, address, onlineTime);
    }

    @Nullable
    public Value getSelfConfigNow(String key) {
        return this.await(this.getSelfConfig(key));
    }

    @Override
    public Mono<Value> getSelfConfig(String key) {
        return this.target.getSelfConfig(key);
    }

    public Values getSelfConfigsNow(Collection<String> keys) {
        return this.await(this.getSelfConfigs(keys));
    }

    @Override
    public Mono<Values> getSelfConfigs(Collection<String> keys) {
        return this.target.getSelfConfigs(keys);
    }

    public Values getSelfConfigsNow(String ... keys) {
        return this.await(this.getSelfConfigs(keys));
    }

    @Override
    public Mono<Values> getSelfConfigs(String ... keys) {
        return this.target.getSelfConfigs(keys);
    }

    public <V> V getSelfConfigNow(ConfigKey<V> key) {
        return this.await(this.getSelfConfig(key));
    }

    @Override
    public <V> Mono<V> getSelfConfig(ConfigKey<V> key) {
        return DeviceOperator.super.getSelfConfig(key);
    }

    public Values getSelfConfigsNow(ConfigKey<?> ... keys) {
        return this.await(this.getSelfConfigs(keys));
    }

    @Override
    public Mono<Values> getSelfConfigs(ConfigKey<?> ... keys) {
        return DeviceOperator.super.getSelfConfigs(keys);
    }

    @Override
    public ThingRpcSupport rpc() {
        return this.target.rpc();
    }

    public boolean isOnlineNow() {
        return Boolean.TRUE.equals(this.await(this.target.isOnline()));
    }

    @Override
    public Mono<Boolean> isOnline() {
        return this.target.isOnline();
    }

    public boolean offlineNow() {
        return Boolean.TRUE.equals(this.await(this.target.offline()));
    }

    @Override
    public Mono<Boolean> offline() {
        return this.target.offline();
    }

    public boolean disconnectNow() {
        return Boolean.TRUE.equals(this.await(this.target.disconnect()));
    }

    @Override
    public Mono<Boolean> disconnect() {
        return this.target.disconnect();
    }

    @Override
    public Mono<AuthenticationResponse> authenticate(AuthenticationRequest request) {
        return this.target.authenticate(request);
    }

    public DeviceMetadata getMetadataNow() {
        return this.await(this.getMetadata());
    }

    @Override
    public Mono<DeviceMetadata> getMetadata() {
        return this.target.getMetadata();
    }

    public ProtocolSupport getProtocolNow() {
        return this.await(this.getProtocol());
    }

    @Override
    public Mono<ProtocolSupport> getProtocol() {
        return this.target.getProtocol();
    }

    @Override
    public DeviceMessageSender messageSender() {
        return this.target.messageSender();
    }

    public boolean updateMetadataNow(String metadata) {
        return Boolean.TRUE.equals(this.await(this.updateMetadata(metadata)));
    }

    @Override
    public Mono<Boolean> updateMetadata(String metadata) {
        return this.target.updateMetadata(metadata);
    }

    public boolean updateMetadataNow(ThingMetadata metadata) {
        return Boolean.TRUE.equals(this.await(this.updateMetadata(metadata)));
    }

    @Override
    public Mono<Boolean> updateMetadata(ThingMetadata metadata) {
        return this.target.updateMetadata(metadata);
    }

    public void resetMetadataNow() {
        this.await(this.resetMetadata());
    }

    @Override
    public Mono<Void> resetMetadata() {
        return this.target.resetMetadata();
    }

    public DeviceProductOperator getProductNow() {
        return this.await(this.getProduct());
    }

    @Override
    public Mono<DeviceProductOperator> getProduct() {
        return this.target.getProduct();
    }

    @Override
    public Mono<DeviceProductOperator> getTemplate() {
        return this.target.getTemplate();
    }

    @Nullable
    public Value getConfigNow(String key) {
        return this.await(this.getConfig(key));
    }

    @Override
    public Mono<Value> getConfig(String key) {
        return this.target.getConfig(key);
    }

    private Values safeValues(Values values) {
        return values == null ? Values.of(Collections.emptyMap()) : values;
    }

    public Values getConfigsNow(Collection<String> keys) {
        return this.safeValues(this.await(this.getConfigs(keys)));
    }

    @Override
    public Mono<Values> getConfigs(Collection<String> keys) {
        return this.target.getConfigs(keys);
    }

    public boolean setConfigNow(String key, Object value) {
        return Boolean.TRUE.equals(this.await(this.setConfig(key, value)));
    }

    @Override
    public Mono<Boolean> setConfig(String key, Object value) {
        return this.target.setConfig(key, value);
    }

    public boolean setConfigNow(ConfigKeyValue<?> keyValue) {
        return Boolean.TRUE.equals(this.await(this.setConfig(keyValue)));
    }

    @Override
    public Mono<Boolean> setConfig(ConfigKeyValue<?> keyValue) {
        return this.target.setConfig(keyValue);
    }

    public <T> boolean setConfigNow(ConfigKey<T> key, T value) {
        return Boolean.TRUE.equals(this.await(this.setConfig(key, value)));
    }

    @Override
    public <T> Mono<Boolean> setConfig(ConfigKey<T> key, T value) {
        return this.target.setConfig(key, value);
    }

    public <T> boolean setConfigsNow(ConfigKeyValue<?> ... keyValues) {
        return Boolean.TRUE.equals(this.await(this.setConfigs(keyValues)));
    }

    @Override
    public Mono<Boolean> setConfigs(ConfigKeyValue<?> ... keyValues) {
        return this.target.setConfigs(keyValues);
    }

    @Nullable
    public <V> V getConfigNow(ConfigKey<V> key) {
        return this.await(this.getConfig(key));
    }

    @Override
    public <V> Mono<V> getConfig(ConfigKey<V> key) {
        return this.target.getConfig(key);
    }

    public Values getConfigsNow(ConfigKey<?> ... key) {
        return this.safeValues(this.await(this.getConfigs(key)));
    }

    @Override
    public Mono<Values> getConfigs(ConfigKey<?> ... key) {
        return this.target.getConfigs(key);
    }

    public Values getConfigsNow(String ... keys) {
        return this.safeValues(this.await(this.getConfigs(keys)));
    }

    @Override
    public Mono<Values> getConfigs(String ... keys) {
        return this.target.getConfigs(keys);
    }

    public boolean setConfigsNow(Map<String, Object> conf) {
        return Boolean.TRUE.equals(this.await(this.setConfigs(conf)));
    }

    @Override
    public Mono<Boolean> setConfigs(Map<String, Object> conf) {
        return this.target.setConfigs(conf);
    }

    public boolean removeConfigNow(String key) {
        return Boolean.TRUE.equals(this.await(this.removeConfig(key)));
    }

    @Override
    public Mono<Boolean> removeConfig(String key) {
        return this.target.removeConfig(key);
    }

    public Value getAndRemoveConfigNow(String key) {
        return this.await(this.getAndRemoveConfig(key));
    }

    @Override
    public Mono<Value> getAndRemoveConfig(String key) {
        return this.target.getAndRemoveConfig(key);
    }

    public boolean removeConfigsNow(Collection<String> key) {
        return Boolean.TRUE.equals(this.await(this.removeConfigs(key)));
    }

    @Override
    public Mono<Boolean> removeConfigs(Collection<String> key) {
        return this.target.removeConfigs(key);
    }

    @Override
    public Mono<Void> refreshConfig(Collection<String> keys) {
        return this.target.refreshConfig(keys);
    }

    @Override
    public Mono<Void> refreshAllConfig() {
        return this.target.refreshAllConfig();
    }

    @Override
    public Mono<Boolean> removeConfigs(ConfigKey<?> ... key) {
        return this.target.removeConfigs(key);
    }

    @Override
    public boolean isWrapperFor(Class<?> type) {
        return this.target.isWrapperFor(type);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return this.target.unwrap(type);
    }

    public BlockingDeviceOperator(DeviceOperator target, Duration timeout, ContextView context) {
        this.target = target;
        this.timeout = timeout;
        this.context = context;
    }
}

