/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.command.AbstractCommandSupport;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandException;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeCommandSupport
implements CommandSupport {
    private final List<AbstractCommandSupport> supports = new CopyOnWriteArrayList<AbstractCommandSupport>();

    public static CommandSupport of(AbstractCommandSupport ... commands) {
        return new CompositeCommandSupport(Arrays.asList(commands));
    }

    public static CompositeCommandSupport create() {
        return new CompositeCommandSupport();
    }

    public CompositeCommandSupport() {
    }

    public CompositeCommandSupport(List<AbstractCommandSupport> supports) {
        this.supports.addAll(supports);
    }

    public List<AbstractCommandSupport> getSupports() {
        return Collections.unmodifiableList(this.supports);
    }

    public void register(AbstractCommandSupport support) {
        this.supports.add(support);
    }

    @Override
    public boolean isWrapperFor(Class<?> type) {
        for (AbstractCommandSupport support : this.supports) {
            if (!support.isWrapperFor(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        for (AbstractCommandSupport support : this.supports) {
            if (!support.isWrapperFor(type)) continue;
            return support.unwrap(type);
        }
        throw new ClassCastException(type.getName());
    }

    @Override
    @Nonnull
    public <R> R execute(@Nonnull Command<R> command) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(command.getCommandId());
            if (!supported) continue;
            return support.execute(command);
        }
        throw this.unsupportedCommand(command);
    }

    private RuntimeException unsupportedCommand(Command<?> command) {
        return new CommandException(this, null, "error.unsupported_command", null, command);
    }

    private RuntimeException unsupportedCommand(String commandId) {
        return new CommandException(this, null, "error.unsupported_command", null, commandId);
    }

    @Override
    public Flux<Object> executeToFlux(Command<?> command) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(command.getCommandId());
            if (!supported) continue;
            return support.executeToFlux(command);
        }
        return Flux.error((Throwable)this.unsupportedCommand(command));
    }

    @Override
    public Flux<Object> executeToFlux(String commandId, Map<String, Object> parameters) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(commandId);
            if (!supported) continue;
            return support.executeToFlux(commandId, parameters);
        }
        return Flux.error((Throwable)this.unsupportedCommand(commandId));
    }

    @Override
    public Mono<Object> executeToMono(Command<?> command) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(command.getCommandId());
            if (!supported) continue;
            return support.executeToMono(command);
        }
        return Mono.error((Throwable)this.unsupportedCommand(command));
    }

    @Override
    public Mono<Object> executeToMono(String commandId, Map<String, Object> parameters) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(commandId);
            if (!supported) continue;
            return support.executeToMono(commandId, parameters);
        }
        return Mono.error((Throwable)this.unsupportedCommand(commandId));
    }

    @Override
    public <R, C extends Command<R>> C createCommand(String commandId) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(commandId);
            if (!supported) continue;
            return support.createCommand(commandId);
        }
        throw this.unsupportedCommand(commandId);
    }

    @Override
    public <R, C extends Command<R>> Mono<C> createCommandAsync(String commandId) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(commandId);
            if (!supported) continue;
            return support.createCommandAsync(commandId);
        }
        return Mono.error((Throwable)this.unsupportedCommand(commandId));
    }

    @Override
    public Flux<FunctionMetadata> getCommandMetadata() {
        return Flux.fromIterable(this.supports).flatMap(CommandSupport::getCommandMetadata);
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(Command<?> command) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(command.getCommandId());
            if (!supported) continue;
            return support.getCommandMetadata(command);
        }
        return Mono.error((Throwable)this.unsupportedCommand(command));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(@Nonnull String commandId, @Nullable Map<String, Object> parameters) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(commandId);
            if (!supported) continue;
            return support.getCommandMetadata(commandId, parameters);
        }
        return Mono.error((Throwable)this.unsupportedCommand(commandId));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(String commandId) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(commandId);
            if (!supported) continue;
            return support.getCommandMetadata(commandId);
        }
        return Mono.error((Throwable)this.unsupportedCommand(commandId));
    }

    @Override
    public Mono<Boolean> commandIsSupported(Command<?> cmd) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(cmd.getCommandId());
            if (!supported) continue;
            return Reactors.ALWAYS_TRUE;
        }
        return Reactors.ALWAYS_FALSE;
    }

    @Override
    public Mono<Boolean> commandIsSupported(Class<? extends Command<?>> cmd) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(CommandUtils.getCommandIdByType(cmd));
            if (!supported) continue;
            return Reactors.ALWAYS_TRUE;
        }
        return Reactors.ALWAYS_FALSE;
    }

    @Override
    public Mono<Boolean> commandIsSupported(String commandId) {
        for (AbstractCommandSupport support : this.supports) {
            boolean supported = support.commandIsSupported0(commandId);
            if (!supported) continue;
            return Reactors.ALWAYS_TRUE;
        }
        return Reactors.ALWAYS_FALSE;
    }
}

